# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# This script is released under the GNU GPLv2


if(description)
{
 script_id(24263);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-0347");
 script_bugtraq_id(22296);

 name["english"] = "CVSTrac text output formatter DoS";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server contains a CGI script or is itself subject to a
denial of service attack. 

Description :

According to its version number, the version of CVSTrac installed on 
the remote host contains a flaw related to its Wiki-style text output 
formatter that may allow an attacker to cause a partial denial of service,
depending on the pages requested. 

See also :

http://www.securityfocus.com/archive/1/458455/30/0/threaded

Solution :

Upgrade to CVSTrac 2.0.1 or later.

Risk factor :

Medium / CVSS Base Score : 1.9
(AV:R/AC:H/Au:NR/C:N/I:N/A:P/B:N)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks CVSTrac version";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2007 David Maciejak");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("cvstrac_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("global_settings.inc");
include("http_func.inc");

if (report_paranoia < 2) exit(0);

port = get_http_port(default:80);
kb = get_kb_item("www/" + port + "/cvstrac" );
if ( ! kb ) exit(0);
stuff = eregmatch(pattern:"(.*) under (.*)", string:kb );
version = stuff[1]; 
if(ereg(pattern:"^([01]\.|2\.0\.0[^0-9.]?)", string:version))
	security_warning(port);
