#TRUSTED 1f74b0d51d71d38daf5115f303c76620a2db1f395b567a82bd977b313ad8d932b0ceb3cd8f4b3126d808c34ac34e4f2b80488f6e7d39a49faa1cc0975ab97e62ee0719cdd76c8f87aeced128f44081e2675e9f9143250ac958bc95cc89d01dcbe624bc7a0f1589c0b861191346eff5bff9d63e0fc4ba11eeb0ff0db2f4edbd02a1fe7dba23e8c9dbb4a0e0f3c749a39c0f35ac260854a3736088f8018728f0c89feb4f5c99016cd4dada7e74eb8f7b503b01d8817945ee25d9fd7b45fc28c754ccf3b030a5a8736090d8d7361b32a3b5afd97ef883065d3030d3d8518667b3cdea325a4e5daa956eacc7eb5c5d47c352415571d741eb23916cad7d616484efdf0700ad12b990e101bcaa858df3e8a783ca71cc129bb865ea5cc09997a7d678f502a8134a5c7d98673d360c28089ef4dbab6ba109f11c4cad5c041fd6ef3e98fae819b2b74b255becb50b345db80d72424e056d3107fdbb601abffae4093b61adeba48a1d20a96871aa9a104b019b52944284b148fd0e897783f5f04b69cd2f189d65c6ba83cd53efc1f011ed6d97495502374077206ff1e90bf38f9aa8a5a6c9cc1baa8c3e5cebe42f1d6d177b46f73ca1b9422280999899e8a1deb7980fa577037ebb91872c2a6522cb63beab8af2497a1e17b624d57758269a9d5a1003a21ab66120d255468627488699103c6871a621b0a899b7d010f9cf425faf5e5271a4
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15869);
 script_version ("1.3");
 name["english"] = "Hydra: Cisco";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find Cisco passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force Cisco authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_timeout(0);
 script_require_keys("Secret/hydra/passwords_file");
 script_require_ports("Services/telnet", 23);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

port = get_kb_item("Services/telnet");
if (! port) exit(0);	# port = 23;
if (! get_port_state(port)) exit(0);

# Check that this is a router
soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv(socket: soc, length: 1024);
close(soc);
if ("Password:" >!< r) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
if (empty)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! empty)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "cisco";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    # l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: 'Hydra/cisco/'+port, value: p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to find the following CISCO passwords:\n' + report);
