#TRUSTED 66c2c26ab23a6ba43de078bbd7634ef2708d2d4ec90f2c858e724e3b44dcba4ddc7bd2b2514472752e66f2c557e4ed2a1cfc353477481c1b5d317e5ab05e241ece8222ef1272e020f62194ad230cd8af0f80178f301cbe6925115b30aa3f51c0b9f0511f78455d98740fa8469829ac6212554427ad997a5f5438c35f7c66f85d24b8ae105962d161740af0122ff126e67dd9d5772ae718fbb31706a7807784c047c82e05127c482755dbe8f87c3e6b27a74288b804672c2bac7da835cac764865ed2983ef29fa13ddc82f2b6634199d0256198cbf07935bfb6e963a1cc08ec1e6238441624bd36618be043386761c2ba5ea2edb2e6905cf234a3c1c740a2aed77d5cf4be49c0c5757c25cceaccfa9fb04ed080d6a33fffaaf7eccb8148ad48c8ac3de9ce81debcff3c0a30313b6537ac381e01453d67dba4f4e951d17d540971c8c1588837480baec2ce5df480a30c414e0cb3d3060be4647eca8a377f50826a1b209b5f9303f411dec236e401bf8e7caf4ff4cf9fb2295200aa96c51e1e613a07ca260c9557cea9291bb376f48b84eb9bbaa0bcd394ad9401b2e66d977ea6cc88bfb5525adc34a88d0278e89110a41d2c66d6900a58b6a4d24fef28a2c4ad333c38944754ff1a2ee1214c9636c56c278aa6dd92c1fddb14c93443dd519dce11d5ff9c29ea099d69a9580618786c86ae0f22edf49bb45445f85a6e7bc1613ca2
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15876);
 script_version ("1.3");
 name["english"] = "Hydra: IMAP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find IMAP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force IMAP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/imap", 143);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/imap");
if (! port) exit(0);	# port = 143;
if (! get_port_state(port)) exit(0);

# Check that the server is up & running
soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv(socket: soc, length: 1024);
close(soc);
if (r !~ '^\\* *OK ') exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "imap";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/imap/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following IMAP accounts:\n' + report);
