#TRUSTED 4f82790b8356b3670b604a2b0d92180d5500a6dee6cee9623865a1e4e65ea3cf687d7a9221f4ded06b0befcd97fabd17d63a2f5bff4a5edd06ffd48b98d4880e7b053f31d2a49f7c066c7db9ca0a7bf37377b7808e040d3c39ceddefbe9534d6fab7744d37f2819fadfcdbc97e2bd2dc1499af541ab6305f1a4dbf8b01f4061ea2b0a885db5ed6a8331a7a48f7c92e5af9ad60c2dd9b1fe276466c6481d96a576760d5f7c08d2614b503bd7444d464e5037aa50f1ae92d58f0192f52a97d01dc28c2f8ed36c4b710418b9b052f9f0be954c550a3fdeb6220b00907b5509e202fab91327666a1ee7e92ed144e21efd2bfb2071e8d697d7c9d8e6480eb7192854ff9004726543e97c71dd451e5211969f62e9853e99eb1d69dd8fc41add956512f5412b273385b70d8a9afca234acfe65ba4db3f37a4c9af165838aed95d98d4a267ad9b3811ae3f17082cf0e858ebb00abe8ec19e5c62daa4a2eaa107a36ca3db144d40486b99c8adc513b9512fc92139fc410dfc826b1db83ee7bb34f92fb817b6b0e3cf9a52c2dfc619b00a548b37c8978eaf1460e63ac6a31a519da10b51a68eb22322f2cb2d722af30ef8033f45954bf655294a3cae3acbf66d5176683d3060e93774ae8f49c16a9b0badcf05cada8bc538e334ff966fb1bf0f236e6474e41b3a4ae198d06f9090ff56bb2db26d71aace94110d3ef08b848085cbc730d4c4
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15883);
 script_version ("1.3");
 name["english"] = "Hydra: SAP R3";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SAP R3 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SAP R3 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_add_preference(name: "Client ID (between 0 and 99) : ", type: "entry", value: "");
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/sap-r3", 3299);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "external_svc_ident.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
 thorough = get_kb_item("global_settings/thorough_tests");
 if ("yes" >!< thorough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/sap-r3");
if (! port) exit(0);	# port = 3299;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

id = script_get_preference("Client ID (between 0 and 99) : ");
if (! id) exit(0);
id = int(id);
if (id < 0 || id > 99) exit(0);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "sapr3";
argv[i++] = id;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/sapr3/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SAP R3 accounts:\n' + report);
