#TRUSTED 5082d8c0f77d968f1b30309f3cfe8ecdb01a54431fe86fd2402169eec35779f236f50ec0b11b7ab921c879768c1c031add062b3e8004fc5921242b412b9725eecbd91c435dc73c048e578c64e6193f60dca7046fdfbe001d088029bcaf9c40258feb25d0546e5f9655ed857be9df417a83648938f6be44a8bf9621468dc3ea523479817e679e8c3727d3660a411775b43888c67e276e38050cb25d7bac883a109fb2a11a9af5a4b6443645ef282aff608ec85ca2ce2a76ce1092666f5165cc41de1a9c3cdc06d7bde4dc8cc9901564438f1f912b600e9aa0c7f8110bcf04724e282b7aeb15c3bcf3f156f1c604c6651ea774a27eebd73ec5330071a51adeec41f8db47039a339973a9bec320ba173192ee49140b71bd1e74241b42c8d3e4e6a41b0ef27302944f5af1a54ce702a15be7a28b85e61dcad648771e486fe993ee2c3e74bc2af458a7df312cc0bdc6094cf7fef3a614854594968e1fdad703066083f36210f8c05eb16e8839cf0cfea01b234bf6301087fd23fcbdba4ed7bb1d10f76f94376bbd1464084e9beefdad4cbfe839985361d714c23159d2dd59ec82b6391d7e3690ee7d57606bdc40e7c58b7185395aa88df51a91beb3405b788a398ff982eb6356ee78791fab697072699f8f0807af453f9677db0d9431f5c9d15011a8ea2339ca144a3e348ffa26a32cbeed1a4b64ed8370985d5942540066008c9bb2
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15886);
 script_version ("1.3");
 name["english"] = "Hydra: SNMP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SNMP passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SNMP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_udp_ports(161, 32789);
 script_dependencies("hydra_options.nasl", "snmp_settings.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

port = get_kb_item("SNMP/port");
if (port) exit(0);
# Yes! We exit if we know the port, and thus some common community name
port = 161;
if (! get_udp_port_state(port)) exit(0);	# Not very reliable, though...

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;

if (empty)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! empty)
 exit(0);

if (exit_asap) argv[i++] = "-f";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "snmp";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: 'Hydra/snmp/'+port, value: p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SNMP communities:\n' + report);
