/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
   File: init.c
   Author: mhandley
   Date: Mon Jul  4 1994
   Purpose: Initialisation of data structures
 */

#include <stdlib.h>
#include <string.h>
#include "prototypes.h"

document *init_document()
{
    document *doc;
    doc = (document *) malloc(sizeof(document));
    doc->checksum = 0;

    /*the document may already exist, but we haven't seen it yet, so we must
       start with time=0 and not the current time */
    doc->last_mod.tv_sec = 0;
    doc->last_mod.tv_usec = 0;

    doc->no_of_pages = 0;
    doc->first_page = NULL;
    return doc;
}

page *init_page(t, prev, next)
struct timeval *t;
page *prev, *next;
{
/*called to setup a new page */

    page *p;

    /*create the page */
    p = (page *) malloc(sizeof(page));

    /*initialise it to something sensible */
    p->last_mod.tv_sec = t->tv_sec;
    p->last_mod.tv_usec = t->tv_usec;
    p->first_block = NULL;
    p->last_block = NULL;

    /*link the page into the page list */
    p->prev_page = (page *) prev;
    if (prev != NULL)
	prev->next_page = p;

    p->next_page = next;
    if (next != NULL)
	next->prev_page = p;

    return p;
}
block *init_block(char *blockid,
		  u_int8 status,
		  u_int8 x,
		  u_int16 y,
		  struct timeval * t,
		  block * prev, block * next,
		  user_data * originator, user_data * modifier,
		  typeface * tface)
{
    block *b;
    ENTRY item;
    /*create the block */
    b = (block *) malloc(sizeof(block));

    /*initialise it to something sensible */
    strncpy(b->blockid, blockid, ID_LEN);
	strcpy(b->checksum, "");
    b->last_mod.tv_sec = t->tv_sec;
    b->last_mod.tv_usec = t->tv_usec;
    b->first_line = NULL;
    b->status = status;
    b->xpos = x;
    b->ypos = y;
    b->no_of_lines = 0;
    b->type = BLOCKMSG;
    b->new_data = 0;
    b->rtx_status = NORMAL_RTX;

    debug("New block: id=%s, x=%d, y=%d\n", b->blockid, b->xpos, b->ypos);
    user_copy(originator, &(b->originator));
    user_copy(modifier, &(b->modifier));
    typeface_copy(tface, &(b->face));

    /*link the block into the block list */
    b->prev_block = prev;
    if (prev != NULL)
	prev->next_block = b;

    b->next_block = next;
    if (next != NULL)
	next->prev_block = b;

    /* add to hashing algorithm */
    debug("&& adding block to hash table\n");
    item.key = b->blockid;
    item.data = (char *) b;
    hsearch(item, ENTER);
    return b;
}

/*Note: previd and nextid are set to "NULL", if prev and next are correct.
   previd and nextid are only set properly if we don't really know where
   this line should go, and will need to fix it later */
line *init_line(lineid, lnum, t, prev, previd, next, nextid)
char *lineid, *previd, *nextid;
struct timeval *t;
line *prev, *next;
int lnum;
{
    line *l;
    ENTRY item;

    /*create the line */
    l = (line *) malloc(sizeof(line));

    /*initialise it to something sensible */
    strncpy(l->lineid, lineid, ID_LEN);		/* set line id, time, don't set text. */
    l->last_mod.tv_sec = t->tv_sec;
    l->last_mod.tv_usec = t->tv_usec;
    l->no_of_chars = 0;
    strcpy(l->line_data, " ");

    /*link the line into the line list */
    /*we know which our neighbours should be */
    l->prev_line = prev;	/* set line pointers, number & no. of missing ines */
    l->next_line = next;
    l->linenum = lnum;
    l->missing_lines = 0;
    l->type = LINEMSG;
    strncpy(l->previd, previd, ID_LEN);		/* being set to "NULL" by most initialization functions? */
    strncpy(l->nextid, nextid, ID_LEN);

    /*and we know they should point to us, but we
       have to be careful not to lose an element of the list by doing this */
    if ((prev != NULL) & (next != NULL)) {	/* if next and previous pointers are OK */
	/*we could have a problem, unless... */
	if ((prev->next_line == next) && (next->prev_line == prev)) {	/* handle insertion between two lines */
	    debug("none NULL - correct\n");
	    /*in this case, our new line is being inserted between
	       two lines that are already neighbouring each other */
	    prev->next_line = l;
	    next->prev_line = l;
	} else {
	    debug("none NULL - but a problem\n");
	    /*things get complicated... */
	    /*either a line got moved, or we received a line earlier
	       and didn't know where it went.  Now we hope we do,
	       but the list needs re-ordering */
#ifdef NDEF
	    sort_lines(l->block);
#endif
	}
    } else if ((prev == NULL) & (next != NULL)) {	/* If only next pointer is OK */
	if (next->prev_line == NULL) {	/* if next line was the first line in block */
	    debug("prev NULL - new first line\n");
	    /*no problem - we just got a new first line */
	    next->prev_line = l;
	} else {		/* if next line points back to something */
	    debug("prev NULL - line missing\n");
	    /*the line before this one must be missing */
	    /*..being careful to leave the list intact */
	    l->prev_line = next->prev_line;
	    next->prev_line->next_line = l;
	    next->prev_line = l;
	}
    } else if ((prev != NULL) & (next == NULL)) {	/* if we don't have a pointer to next */
	if (prev->next_line == NULL) {
	    debug("next NULL - new last line\n");
	    /*no problem - we just got a new last line */
	    prev->next_line = l;
	} else {
	    debug("next NULL - line missing\n");
	    /*the line after this one must be missing */
	    /*..being careful to leave the list intact */
	    l->next_line = prev->next_line;
	    prev->next_line->prev_line = l;
	    prev->next_line = l;
	}
    } else {
	/*both prev and next are NULL */
	debug("both NULL\n");
	/*if the list already has elements and this got called, 
	   then there's a problem */
    }



    debug("&& adding line to hash table\n");
    item.key = l->lineid;
    item.data = (char *) l;
    hsearch(item, ENTER);

    debug("New line:%s\n", lineid);
    return l;
}

document *doc;
page *p;
user_data me;
typeface tf;
int init_ds()
{
    struct timeval t;
    init_local_user(&me);
    doc = (document *) init_document();
    t.tv_sec = 0;
    t.tv_usec = 0;
    p = (page *) init_page(&t, NULL, NULL);
    return 0;
}
