/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <string.h>
#include "prototypes.h"
#define PARANOIA
missing_list ml;

void init_missing_list(missing_list * ml)
{
    ml->no_of_entries = 0;
}


void add_to_missing_list(char *id, int type)
{
#ifdef ABORT
    if (ml.no_of_entries > MAX_NUMBER_MISSING || ml.no_of_entries < 0)
	abort();
#endif
    if ((is_in_missing_list(id) == FALSE) && (strncmp(id, "NULL", ID_LEN) != 0)) {
	strncpy(ml.entries[ml.no_of_entries].id, id, ID_LEN);
	ml.entries[ml.no_of_entries].type = type;
	ml.no_of_entries++;
    }
#ifdef ABORT
    if (ml.no_of_entries > MAX_NUMBER_MISSING || ml.no_of_entries < 0)
	abort();
#endif
}

void rm_from_missing_list(char *id)
{
    int posn;
#ifdef ABORT
    if (ml.no_of_entries > MAX_NUMBER_MISSING || ml.no_of_entries < 0)
	abort();
#endif
    if ((posn = posn_in_missing_list(id)) == -1)
	return;
    if (posn != (ml.no_of_entries - 1)) {
	strncpy(ml.entries[posn].id, ml.entries[ml.no_of_entries - 1].id, ID_LEN);
	ml.entries[posn].type = ml.entries[ml.no_of_entries - 1].type;
    }
    ml.no_of_entries--;
}

int number_missing()
{
#ifdef ABORT
    if (ml.no_of_entries > MAX_NUMBER_MISSING || ml.no_of_entries < 0)
	abort();
#endif
    return (ml.no_of_entries);
}

int is_in_missing_list(char *id)
{
    int i;
#ifdef ABORT
    if (ml.no_of_entries > MAX_NUMBER_MISSING || ml.no_of_entries < 0)
	abort();
#endif
    for (i = 0; i < ml.no_of_entries; i++) {
	if (strncmp(ml.entries[i].id, id, ID_LEN) == 0)
	    return TRUE;
    }
    return FALSE;
}

int posn_in_missing_list(char *id)
{
    int i;
#ifdef ABORT
    if (ml.no_of_entries > MAX_NUMBER_MISSING || ml.no_of_entries < 0)
	abort();
#endif
    for (i = 0; i < ml.no_of_entries; i++) {
	if (strncmp(ml.entries[i].id, id, ID_LEN) == 0)
	    return i;
    }
    return -1;
}

char *get_missing_id(int index)
{
    return (ml.entries[index].id);
}
