// file kernel/n/alpha/add.S: addition/subtraction of natural integers
/*-----------------------------------------------------------------------+
 |  Copyright 2005-2006, Michel Quercia (michel.quercia@prepas.org)      |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                         Addition/soustraction                         |
 |                                                                       |
 +-----------------------------------------------------------------------*/

                           # +---------------------+
                           # |  Addition droule  |
                           # +---------------------+

   # entre en milieu de boucle :
   #   r1:r0 = retenue entrante (dont le 1er chiffre de (r16))
   #   r2  = -(longueur des oprandes)
   #   r16 = adresse oprande cadre sur un multiple de 32
   #   r18 = adresse oprande cadre sur un multiple de 32
   #   r20 = adresse rsultat cadre sur un multiple de 32
   #   r27 = adresse de retour
   #
   # sortie:
   #   (r20) <- (r16) + (r18)
   #   r0 <- retenue sortante
   #   r1 <- dernier chiffre du rsultat
   #
   # registres modifis:
   #   r2 <- r2 + 32*ceil(r2/32) 
   #   r3 <- ind
   #   r16 <- adresse suivante pour le premier oprande
   #   r18 <- adresse suivante pour le deuxime oprande
   #   r20 <- adresse suivante pour le rsultat

        .align 5
        .globl sn_addloop
        .ent   sn_addloop
        .frame $30,0,$27,0
        .prologue 0

        # corps de boucle  drouler (8 instructions, entrer  la 4me)
#define BODY(x) \
        ldq    $1,   x($16)     ;\
        addq   $0,   $1,   $1   ;\
        cmpult $1,   $0,   $0   ;\
        ldq    $3,   x($18)     ;\
        addq   $3,   $1,   $1   ;\
        cmpult $1,   $3,   $3   ;\
        stq    $1,   x($20)     ;\
	addq   $3,   $0,   $0

	# boucle droule pour 32 chiffres
sn_addloop:
        BODY(0);   BODY(8);   BODY(16);  BODY(24)
        BODY(32);  BODY(40);  BODY(48);  BODY(56)
        BODY(64);  BODY(72);  BODY(80);  BODY(88)
        BODY(96);  BODY(104); BODY(112); BODY(120)
        BODY(128); BODY(136); BODY(144); BODY(152)
        BODY(160); BODY(168); BODY(176); BODY(184)
        BODY(192); BODY(200); BODY(208); BODY(216)
        BODY(224); BODY(232); BODY(240); BODY(248)
#undef BODY

	lda    $2,   32($2)
	lda    $16,  256($16)
	lda    $18,  256($18)
	lda    $20,  256($20)
	blt    $2,   sn_addloop
	ret    $31,  ($27),1

	.end   sn_addloop

                               # +------------+
                               # |  Addition  |
                               # +------------+

   #  chiffre xn(add)(chiffre *a, long la, chiffre *b, long lb, chiffre *c)
   # 
   #  entre :
   #  a = naturel de longueur la
   #  b = naturel de longueur lb <= la
   #  c = aturel de longueur la
   # 
   #  sortie :
   #  c <- a + b
   #  retourne la retenue

#ifdef assembly_sn_add
#define L(x) .Lsn_add_##x
#define _a_  $16
#define _b_  $18
#define _c_  $20
#define _la_ $17
#define _lb_ $19

        .align 5
        .globl sn_add
        .ent   sn_add
sn_add:
        .frame $30,0,$26,0
        .prologue 1
	ldgp   $gp,  0($27)
L(nogp):
	
	# additionne les chiffres communs
	bis    $31,  $31,  $0   # r0 <- 0 (retenue)
	beq    _lb_, 1f
	ldq    $1,   0(_a_)     # r1 <- a[0] (retenue)
	subq   _la_, _lb_,  _la_# la <- la - lb
	subq   $31,  _lb_,  $2  # r2 <- -lb
	and    $2,   31,    $3	# r3 <- (-lb) % 32
	bic    $2,   31,    $2  # r2 <- -32*ceil(lb/32)
	sll    $3,   3,     $3  # r3 <- 8*((-lb) % 32)
	subq   _a_,  $3,    _a_ # cadre a,b,c sur le multiple de 32 prcdent
	subq   _b_,  $3,    _b_
	subq   _c_,  $3,    _c_
	lda    $27,  sn_addloop
	addq   $3,   3,     $3  # r3 <- nb d instructions a sauter
	s4addq $3,   $27,   $27 # r27 <- adresse d entre dans la boucle
	jsr    $27,  ($27)	# effectue l addition
1:

        # propage la retenue
        beq    _la_, 3f
        .align 5
2:
        ldq    $1,   0(_a_)     # r1 <- a[i]
        lda    _a_,  8(_a_)     # a++
        lda    _la_, -1(_la_)   # (la-lb)--
        addq   $1,   $0,   $1   # r1 += r
        cmpult $1,   $0,   $0   # r0 <- retenue
        stq    $1,   0(_c_)     # c[i] <- low(res)
        lda    _c_,  8(_c_)     # c++
        bne    _la_, 2b
3:
        ret    $31,  ($26),1

	.end sn_add

#undef L
#undef _a_
#undef _b_
#undef _c_
#undef _la_
#undef _lb_
#else
	REPLACE(sn_add)	
#endif /* assembly_sn_add */

                            # +------------------+
                            # |  Incrmentation  |
                            # +------------------+

   #  chiffre xn(inc)(chiffre *a, long la, chiffre *b, long lb)
   #  entre :
   #  a = naturel de longueur la
   #  b = naturel de longueur lb avec lb <= la
   #
   #  sortie :
   #  a <- a + b
   #  retourne la retenue

#ifdef assembly_sn_inc
#define L(x) .Lsn_inc_##x
#define _a_  $16
#define _b_  $18
#define _c_  $20
#define _la_ $17
#define _lb_ $19

        .align 5
        .globl sn_inc
        .ent   sn_inc
sn_inc:
        .frame $30,0,$26,0
        .prologue 1
	ldgp   $gp,  0($27)
L(nogp):

	# additionne les chiffres communs
	bis    $31,  $31,  $0   # r0 <- 0 (retenue)
	beq    _lb_, 1f
	ldq    $1,   0(_a_)     # r1 <- a[0] (retenue)
	subq   $31,  _lb_,  $2  # r2 <- -lb
	and    $2,   31,    $3	# r3 <- (-lb) % 32
	bic    $2,   31,    $2  # r2 <- -32*ceil(lb/32)
	sll    $3,   3,     $3  # r3 <- 8*((-lb) % 32)
	subq   _a_,  $3,    _a_ # cadre a,b,c sur le multiple de 32 prcdent
	subq   _b_,  $3,    _b_
	bis    _a_,  _a_,   _c_
	lda    $27,  sn_addloop
	addq   $3,   3,     $3  # r3 <- nb d instructions a sauter
	s4addq $3,   $27,   $27 # r27 <- adresse d entre dans la boucle
	jsr    $27,  ($27)	# effectue l addition
1:

        # propage la retenue
	subq   _la_, _lb_,  $2	# r2 <- la - lb
	bis    $26,  $26,   $27	# r27 <- adresse de retour
	
	.end sn_inc

#undef _a_
#undef _b_
#undef _c_
#undef _la_
#undef _lb_
#undef L
#else
	REPLACE(sn_inc)	
#endif /* assembly_sn_inc */

   # entre:
   #   r0  = retenue entrante
   #   r2  = longueur de l oprande
   #   r20 = adresse de l oprande
   #   r27 = adresse de retour
   #    
   # sortie:
   #   (r20) <- r0 + (r20)
   #   r0 <- retenue sortante
   #   r2 <- r2 - nb chiffres modifis
   #   r20 <- adresse premier chiffre non modifi	
   #
   # registres modifis:
   #   r1 <- ind.

        .globl sn_incloop
        .ent   sn_incloop
        .frame $30,0,$27,0
        .prologue 0

sn_incloop:
	beq    $0,   2f
        beq    $2,   2f
1:
        ldq    $1,   0($20)
        lda    $2,   -1($2)
        addq   $1,   $0,   $1
        cmpult $1,   $0,   $0
        stq    $1,   0($20)
	lda    $20,  8($20)
	beq    $0,   2f
        bne    $2,   1b
2:
        ret    $31,  ($27),1
	.end   sn_incloop

	
                         # +-------------------------+
                         # |  Soustraction droule  |
                         # +-------------------------+

   # entre en milieu de boucle :
   #   r1:r0 = retenue entrante (dont le 1er chiffre de (r18))
   #   r2  = -(longueur des oprandes)
   #   r16 = adresse oprande cadre sur un multiple de 32
   #   r18 = adresse oprande cadre sur un multiple de 32
   #   r20 = adresse rsultat cadre sur un multiple de 32
   #   r27 = adresse de retour
   #
   # sortie:
   #   (r20) <- (r16) - (r18)
   #   r0 <- retenue sortante
   #   r1 <- dernier chiffre du rsultat
   #
   # registres modifis:
   #   r2 <- r2 + 32*ceil(r2/32) 
   #   r3 <- ind
   #   r16 <- adresse suivante pour le premier oprande
   #   r18 <- adresse suivante pour le deuxime oprande
   #   r20 <- adresse suivante pour le rsultat

        .align 5
        .globl sn_subloop
        .ent   sn_subloop
        .frame $30,0,$27,0
        .prologue 0

        # corps de boucle  drouler (8 instructions, entrer  la 4me)
#define BODY(x) \
        ldq    $1,   x($18)     ;\
        addq   $0,   $1,   $1   ;\
        cmpult $1,   $0,   $0   ;\
        ldq    $3,   x($16)     ;\
        subq   $3,   $1,   $1   ;\
        cmpult $3,   $1,   $3   ;\
        stq    $1,   x($20)     ;\
	addq   $3,   $0,   $0

	# boucle droule pour 32 chiffres
sn_subloop:
        BODY(0);   BODY(8);   BODY(16);  BODY(24)
        BODY(32);  BODY(40);  BODY(48);  BODY(56)
        BODY(64);  BODY(72);  BODY(80);  BODY(88)
        BODY(96);  BODY(104); BODY(112); BODY(120)
        BODY(128); BODY(136); BODY(144); BODY(152)
        BODY(160); BODY(168); BODY(176); BODY(184)
        BODY(192); BODY(200); BODY(208); BODY(216)
        BODY(224); BODY(232); BODY(240); BODY(248)
#undef BODY

	lda    $2,   32($2)
	lda    $16,  256($16)
	lda    $18,  256($18)
	lda    $20,  256($20)
	blt    $2,   sn_subloop
	ret    $31,  ($27),1

	.end   sn_subloop

                             # +----------------+
                             # |  Soustraction  |
                             # +----------------+


   #  chiffre xn(sub)(chiffre *a, long la, chiffre *b, long lb, chiffre *c)
   # 
   #  entre :
   #  a = naturel de longueur la
   #  b = naturel de longueur lb <= la
   #  c = naturel de longueur la
   # 
   #  sortie :
   #  c <- a - b
   #  retourne la retenue

#ifdef assembly_sn_sub
#define L(x) .Lsn_sub_##x
#define _a_  $16
#define _b_  $18
#define _c_  $20
#define _la_ $17
#define _lb_ $19

        .align 5
        .globl sn_sub
        .ent   sn_sub
sn_sub:
        .frame $30,0,$26,0
        .prologue 1
	ldgp   $gp,  0($27)
L(nogp):
	
	# retranche les chiffres communs
	bis    $31,  $31,  $0   # r0 <- 0 (retenue)
	beq    _lb_, 1f
	ldq    $1,   0(_b_)     # r1 <- b[0] (retenue)
	subq   _la_, _lb_,  _la_# la <- la - lb
	subq   $31,  _lb_,  $2  # r2 <- -lb
	and    $2,   31,    $3	# r3 <- (-lb) % 32
	bic    $2,   31,    $2  # r2 <- -32*ceil(lb/32)
	sll    $3,   3,     $3  # r3 <- 8*((-lb) % 32)
	subq   _a_,  $3,    _a_ # cadre a,b,c sur le multiple de 32 prcdent
	subq   _b_,  $3,    _b_
	subq   _c_,  $3,    _c_
	lda    $27,  sn_subloop
	addq   $3,   3,     $3  # r3 <- nb d instructions a sauter
	s4addq $3,   $27,   $27 # r27 <- adresse d entre dans la boucle
	jsr    $27,  ($27)	# effectue la soustraction
1:

        # propage la retenue
        beq    _la_, 3f
        .align 5
2:
        ldq    $1,   0(_a_)     # r1 <- a[i]
        lda    _a_,  8(_a_)     # a++
        lda    _la_, -1(_la_)   # (la-lb)--
        subq   $1,   $0,   $2   # r2 <- a[i] - r
        cmpult $1,   $2,   $0   # r0 <- retenue
        stq    $2,   0(_c_)     # c[i] <- low(res)
        lda    _c_,  8(_c_)     # c++
        bne    _la_, 2b
3:
        ret    $31,  ($26),1

	.end sn_sub

#undef L
#undef _a_
#undef _b_
#undef _c_
#undef _la_
#undef _lb_
#else
	REPLACE(sn_sub)
#endif /* assembly_sn_sub */

                            # +------------------+
                            # |  Dcrmentation  |
                            # +------------------+

   #  chiffre xn(dec)(chiffre *a, long la, chiffre *b, long lb)
   #  entre :
   #  a = naturel de longueur la
   #  b = naturel de longueur lb avec lb <= la
   #
   #  sortie :
   #  a <- a - b
   #  retourne la retenue

#ifdef assembly_sn_dec
#define L(x) .Lsn_dec_##x
#define _a_  $16
#define _b_  $18
#define _c_  $20
#define _la_ $17
#define _lb_ $19

        .align 5
        .globl sn_dec
        .ent   sn_dec
sn_dec:
        .frame $30,0,$26,0
        .prologue 1
	ldgp   $gp,  0($27)
L(nogp):

	# retranche les chiffres communs
	bis    $31,  $31,  $0   # r0 <- 0 (retenue)
	beq    _lb_, 1f
	ldq    $1,   0(_b_)     # r1 <- b[0] (retenue)
	subq   $31,  _lb_,  $2  # r2 <- -lb
	and    $2,   31,    $3	# r3 <- (-lb) % 32
	bic    $2,   31,    $2  # r2 <- -32*ceil(lb/32)
	sll    $3,   3,     $3  # r3 <- 8*((-lb) % 32)
	subq   _a_,  $3,    _a_ # cadre a,b,c sur le multiple de 32 prcdent
	subq   _b_,  $3,    _b_
	bis    _a_,  _a_,   _c_
	lda    $27,  sn_subloop
	addq   $3,   3,     $3  # r3 <- nb d instructions a sauter
	s4addq $3,   $27,   $27 # r27 <- adresse d entre dans la boucle
	jsr    $27,  ($27)	# effectue l addition
1:

        # propage la retenue
	subq   _la_, _lb_,  $2	# r2 <- la - lb
	bis    $26,  $26,   $27	# r27 <- adresse de retour
	
	.end sn_dec

#undef L
#undef _a_
#undef _b_
#undef _c_
#undef _la_
#undef _lb_
#else
	REPLACE(sn_dec)	
#endif /* assembly_sn_dec */

   # entre:
   #   r0  = retenue entrante
   #   r2  = longueur de l oprande
   #   r20 = adresse de l oprande
   #   r27 = adresse de retour
   #    
   # sortie:
   #   (r20) <- (r20) - r0
   #   r0 <- retenue sortante
   #   r2 <- r2 - nb chiffres modifis
   #   r20 <- adresse premier chiffre non modifi	
   #
   # registres modifis:
   #   r1 <- ind.

        .globl sn_decloop
        .ent   sn_decloop
        .frame $30,0,$27,0
        .prologue 0

sn_decloop:
	beq    $0,   2f
        beq    $2,   2f
1:
        ldq    $1,   0($20)
        lda    $2,   -1($2)
        subq   $1,   $0,   $0
        stq    $0,   0($20)
        cmpult $1,   $0,   $0
	lda    $20,  8($20)
	beq    $0,   2f
        bne    $2, 1b
2:
        ret    $31,  ($27),1
	.end   sn_decloop


                    # +-----------------------------------+
                    # |  Valeur absolue de la diffrence  |
                    # +-----------------------------------+

   # chiffre xn(asub)(chiffre *a, long la, chiffre *b, long lb, chiffre *c)
   # entre :
   #   a = naturel de longueur la
   #   b = naturel de longueur lb
   #   c = naturel de longueur la, peut tre confondu avec a ou b
   # contraintes : la >= lb > 0
   #
   # sortie :
   #   c <- |a-b|
   #   retourne 0 si a >= b, 1 sinon
   #
   # remarque :
   #   fonction non implmente en C
   #
   # registres modifis :
   #   r0 <- rsultat
   #   r1,r2,r3,r4 <- ind.
   #   a,b,c,la,lb <- ind.

#define L(x) .Lsn_asub_##x
#define _a_  $16
#define _b_  $18
#define _c_  $20
#define _la_ $17
#define _lb_ $19

        .align 5
        .globl sn_asub
        .ent   sn_asub
sn_asub:
        .frame $30,0,$26,0
        .prologue 1
	ldgp   $gp,  0($27)
L(nogp):

	s8addq _la_, _a_,  $1   # r1 <- &a[la]
	s8addq _lb_, _b_,  $2   # r2 <- &b[lb]
	s8addq _la_, _c_,  $3   # r3 <- &c[la]
        subq   _la_, _lb_, _la_ # la <- la - lb
	bis    $31,  $31,  $4   # r4 <- 0 (rsultat)

	# recopie les zros de tte de a tant que la > lb
	beq    _la_, 2f
1:
	lda    $1,   -8($1)
	lda    $3,   -8($3)
	ldq    $0,   0($1)
	bne    $0,   4f
	lda    _la_,  -1(_la_)
	stq    $31,  0($3)
	bne    _la_,  1b
	
	# soustrait les chiffres de poids fort de a et b tant qu ils sont gaux
2:
	lda    $1,   -8($1)
	lda    $2,   -8($2)
	lda    $3,   -8($3)
	ldq    $0,   0($1)
	ldq    $4,   0($2)
	subq   $4,   $0,   $0
	bne    $0,   3f
	lda    _lb_,  -1(_lb_)
	stq    $31,  0($3)
	bne    _lb_, 2b
        ret    $31,  ($26),1

	# ici a et b ont un chiffre de tte diffrent. Si a < b, les change
	.align 5
3:
	cmpule $0,   $4,   $4
	beq    $4,   4f
	bis    _a_,  _a_,  $1
	bis    _b_,  _b_,  _a_
	bis    $1,   $1,   _b_
4:

	# retranche les chiffres communs
	bis    $31,  $31,   $0  # r0 <- 0 (retenue)
	ldq    $1,   0(_b_)     # r1 <- b[0] (retenue)
	subq   $31,  _lb_,  $2  # r2 <- -lb
	and    $2,   31,    $3	# r3 <- (-lb) % 32
	bic    $2,   31,    $2  # r2 <- -32*ceil(lb/32)
	sll    $3,   3,     $3  # r3 <- 8*((-lb) % 32)
	subq   _a_,  $3,    _a_ # cadre a,b,c sur le multiple de 32 prcdent
	subq   _b_,  $3,    _b_
	subq   _c_,  $3,    _c_
	lda    $27,  sn_subloop
	addq   $3,   3,     $3  # r3 <- nb d instructions a sauter
	s4addq $3,   $27,   $27 # r27 <- adresse d entre dans la boucle
	jsr    $27,  ($27)	# effectue la soustraction

        # propage la retenue
        bne    _la_, 5f
	bis    $4,   $4,   $0   # r0 <- rsultat de la comparaison
        ret    $31,  ($26),1
        .align 5
5:
        ldq    $1,   0(_a_)     # r1 <- a[i]
        lda    _a_,  8(_a_)     # a++
        lda    _la_, -1(_la_)   # (la-lb)--
        subq   $1,   $0,   $2   # r2 <- a[i] - r
        cmpult $1,   $2,   $0   # r0 <- retenue
        stq    $2,   0(_c_)     # c[i] <- low(res)
        lda    _c_,  8(_c_)     # c++
        bne    _la_, 5b
        ret    $31,  ($26),1    # ici r0 = 0 (rsultat correct)

	.end sn_asub

#undef L
#undef _a_
#undef _b_
#undef _c_
#undef _la_
#undef _lb_

                    # +----------------------------------+
                    # |  Addition/soustraction droule  |
                    # +----------------------------------+

   # entre en milieu de boucle :
   #   r0,r1 = retenues entrantes
   #   r2  = -(longueur des oprandes)
   #   r16 = adresse oprande cadre sur un multiple de 32
   #   r18 = adresse oprande cadre sur un multiple de 32
   #   r20 = adresse rsultat cadre sur un multiple de 32
   #   r21 = adresse rsultat cadre sur un multiple de 32
   #   r27 = adresse de retour
   #
   # sortie:
   #   (r20) <- (r16) + (r18) + r0
   #   (r21) <- (r16) - (r18) - r1
   #   r0,r1 <- retenues sortantes
   #
   # registres modifis:
   #   r2 <- r2 + 32*ceil(r2/32) 
   #   r3,r4,r5,r6 <- ind
   #   r16 <- adresse suivante pour le premier oprande
   #   r18 <- adresse suivante pour le deuxime oprande
   #   r20 <- adresse suivante pour le premier rsultat
   #   r20 <- adresse suivante pour le deuxime rsultat

        .align 5
        .globl sn_addsubloop
        .ent   sn_addsubloop
        .frame $30,0,$27,0
        .prologue 0

	# corps de boucle  drouler (14 instructions, entrer  la premire)
#define BODY(x) \
        ldq    $3,   x($16)     ;\
        ldq    $4,   x($18)     ;\
        addq   $3,   $0,   $5   ;\
        cmpult $5,   $0,   $0   ;\
        addq   $4,   $1,   $6   ;\
        cmpult $6,   $1,   $1   ;\
	addq   $5,   $4,   $5   ;\
	subq   $3,   $6,   $6   ;\
        stq    $5,   x($20)     ;\
        stq    $6,   x($21)     ;\
	cmpult $5,   $4,   $4   ;\
	cmpult $3,   $6,   $3   ;\
	addq   $4,   $0,   $0   ;\
	addq   $3,   $1,   $1

	# boucle droule pour 32 chiffres
sn_addsubloop:
        BODY(0);   BODY(8);   BODY(16);  BODY(24)
        BODY(32);  BODY(40);  BODY(48);  BODY(56)
        BODY(64);  BODY(72);  BODY(80);  BODY(88)
        BODY(96);  BODY(104); BODY(112); BODY(120)
        BODY(128); BODY(136); BODY(144); BODY(152)
        BODY(160); BODY(168); BODY(176); BODY(184)
        BODY(192); BODY(200); BODY(208); BODY(216)
        BODY(224); BODY(232); BODY(240); BODY(248)
#undef BODY

	lda    $2,   32($2)
	lda    $16,  256($16)
	lda    $18,  256($18)
	lda    $20,  256($20)
	lda    $21,  256($21)
	blt    $2,   sn_addsubloop
	ret    $31,  ($27),1

	.end   sn_addsubloop

                      # +------------------------------+
                      # |  Demi addition/soustraction  |
                      # +------------------------------+
	
   # void xn(half_addsub)(chiffre *a, chiffre *b, chiffre *c, chiffre *d, long n)
   #
   # entre :
   #   a,b,c,d = naturel de longueur 
   # contraintes : n > 1, a+b pair
   #
   # sortie :
   #   c <- (a+b)/2
   #   d <- (a-b)/2 mod BASE^n

#define L(x) .Lsn_half_addsub_##x
	
        .align 5
        .globl sn_half_addsub
        .ent   sn_half_addsub
sn_half_addsub:
        .frame $30,0,$26,0
        .prologue 1
	ldgp   $gp,  0($27)
L(nogp):

	ldq    $1,  0($16)      # r1 <- a[0]
	ldq    $2,  0($17)      # r2 <- b[0]
	lda    $5,  1($31)
	subq   $5,  $20, $20	# r20 <- 1-n
	and    $20, 31,  $5     # r5 <- (1-n) mod 32
	bic    $20, 31,  $20    # r20 <- -32*ceil((n-1)/32)
	sll    $5,  3,   $6
	subq   $16, $6,  $16    # cadre les pointeurs sur le multiple
	subq   $17, $6,  $17    # de 32 prcdent
	subq   $18, $6,  $18
	subq   $19, $6,  $19
	sll    $6,  1,   $6
	addq   $5,  $6,  $6     # r6 <- 17*((1-n) mod 32)
	lda    $27, L(loop)
	s4addq $6,  $27, $27    # r27 <- adresse de saut dans la boucle

	# premiers chiffres
	addq   $1,  $2,  $1
	cmpult $1,  $2,  $0     # r0 <- retenue(a+b)
	srl    $1,  1,   $1     # r1 <- (a[0]+b[0])/2
	bis    $31, $31, $3     # r3 <- retenue((a-b)/2)
	jmp    $31, ($27)

	# corps de boucle  drouler (17 instructions, entrer  la premire)
#define BODY(x,y) \
        ldq    $5,   x($16)     ;\
        ldq    $6,   x($17)     ;\
	addq   $5,   $0,   $5   ;\
	cmpult $5,   $0,   $0   ;\
	addq   $5,   $6,   $5   ;\
	cmpult $5,   $6,   $4   ;\
	addq   $4,   $0,   $0   ;\
	sll    $5,   63,   $4   ;\
	addq   $4,   $1,   $1   ;\
	stq    $1,   y($18)     ;\
	subq   $1,   $2,   $2   ;\
	stq    $2,   y($19)     ;\
	cmpult $1,   $2,   $2   ;\
	addq   $2,   $3,   $3   ;\
	addq   $6,   $3,   $2   ;\
	cmpult $2,   $3,   $3   ;\
	srl    $5,   1,    $1

	# boucle droule pour 32 chiffres
	.align 5
L(loop):
        BODY(8,  0);   BODY(16, 8);   BODY(24, 16);  BODY(32, 24)
        BODY(40, 32);  BODY(48, 40);  BODY(56, 48);  BODY(64, 56)
        BODY(72, 64);  BODY(80, 72);  BODY(88, 80);  BODY(96, 88)
        BODY(104,96);  BODY(112,104); BODY(120,112); BODY(128,120)
        BODY(136,128); BODY(144,136); BODY(152,144); BODY(160,152)
        BODY(168,160); BODY(176,168); BODY(184,176); BODY(192,184)
        BODY(200,192); BODY(208,200); BODY(216,208); BODY(224,216)
        BODY(232,224); BODY(240,232); BODY(248,240); BODY(256,248)
#undef BODY

	lda    $20,  32($20)
	lda    $16,  256($16)
	lda    $17,  256($17)
	lda    $18,  256($18)
	lda    $19,  256($19)
	blt    $20,  L(loop)

	# derniers chiffres
	sll    $0,   63,   $4
	addq   $4,   $1,   $1
	stq    $1,   0($18)
	subq   $1,   $2,   $2
	stq    $2,   0($19)
	ret    $31, ($26),1

	.end   sn_half_addsub
#undef L

