/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*             Damien Doligez, projet Para, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1998 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License, with    */
/*  the special exception on linking described in file ../LICENSE.     */
/*                                                                     */
/***********************************************************************/

/* $Id: ocaml.r,v 1.10 2001/12/07 13:39:47 xleroy Exp $ */

#include "Types.r"

#include "ocamlconstants.h"

resource 'vers' (1) {
#define d development
#define a alpha
#define b beta
  MAJORVNUM, MINORVNUM, STAGE, DEVVNUM,
  0,
  VERSIONSTR,
  "Objective Caml version " VERSIONSTR "\n"
  COPYRIGHTSTR
#undef d
#undef a
#undef b
};

data 'Line' (1000) {  /* kCommandLineTemplate */
  "%a\000"
};

data 'Line' (1001) {  /* kEnvironmentTemplate */
  "TempFolder=%t\000"
  "CAMLLIB=%dstdlib:\000"
};

data 'TEXT' (1000, purgeable) {  /* kAboutText1 */
  "Objective Caml version " VERSIONSTR "\n"
  COPYRIGHTSTR "\n"
  "\n"
  "Xavier Leroy, Jerme Vouillon, Jacques Garrigue, Damien Doligez, et al.\n"
  "\n"
  "\n"
};


/*****************************************************************
  derez -m 60 caml-icons.rsrc "{rincludes}types.r" 
        "{rincludes}finder.r" "{rincludes}icons.r" >> ocaml.r
*/

resource 'icl4' (1000) {
    $"0000 0000 000F FFFF F000 0000 0000 0000 0000 0000 00FF FFFF"
    $"FFF0 0000 0000 0000 0000 0000 FFFF FFFF FFFF 0000 0000 0000"
    $"FFFF FF0F FFFF BBBB BBBF F000 00FF FFF0 FAAA AAFF FFBB BBBB"
    $"BBBB BFFF FFFF FFF0 FAAA AAAF FFFF FFFF FFFF FFFF FFFF FFF0"
    $"FAAA AAAA FFFD DDFF FFFF FFFF FFFF FF00 FFAA AAAA AFFF CCFF"
    $"FFFF FFFF FFFF FF00 0FFA AAAA AAFF FCFF FFFF FBBF FFFF F000"
    $"00FF FAAA AAAF FFFF FFFF BBBB FFFF 0000 0000 FFAA AAAA FFFF"
    $"FFFF BBBB BBFF 0000 0000 0FFA AAAA AFFF FFFA ABBB BBBF F000"
    $"0000 0FFA AAAA ABBB BBFF AABB BBBB FF00 0000 FFFA AAAA BBBB"
    $"BBBF FAAB BBBB BFF0 0000 FFFA AAAB BBBB BBBB FFAA BBBB BBFF"
    $"0000 FFFA AAAB BBBB FFBB BFFA ABBB BBFF 0000 FFFA AAAB BBBB"
    $"FFBB BBFF AABA BBFF 0000 FFFA AAAB BBBB FFBB BBBF FAAA AAFF"
    $"0000 FFFA AAAB BBBB FFBB BBBB FFAA AAFF 0000 FFFA AAAA BBBB"
    $"FFBB BBBB BFFA AFFF 0000 FFFF AAAA ABBB FFFB BBBB BBFF AFBF"
    $"0000 0FFF AAAA AABB FFFB BBBB BBBF FFBF 0000 00FF AAAA AAA1"
    $"81FB BBBB BBBF FBBF 0000 000F AAAA A81A AFFF BBBB BBBF FBBF"
    $"0000 000F AAA1 8AAA AFFF FBBB BBBF FBBF 0000 00FF A81A 1AAA"
    $"AAAF FFBB BBBF FBBF 0000 00FA 11AA 8AAA AAAA FFFB BBFF FBF0"
    $"0000 0FF8 A8AA AAAA AAAA AFFF BFFF FBF0 0000 0F8A A8AA AAAA"
    $"AAAA AAFF FFFF FF00 0000 FFAA AAAA AAAA AAAA AFFF FFF0 0000"
    $"0000 FAAA AAAA AAAA AAAA FF00 0000 0000 0000 FFFF FFFF FFFF"
    $"FFFF F0"
};

resource 'icl4' (1001) {
    $"0FFF FFFF FFFF FFFF FFFF 0000 0000 0000 0F00 0000 0000 0000"
    $"000F F000 0000 0000 0F00 0000 0000 0000 000F CF00 0000 0000"
    $"0F00 0000 0FFF FF00 000F 0CF0 0000 0000 0F00 FFFF FFBB BFFF"
    $"FFFF 00CF 0000 0000 0F00 FAAF FFFF FFFF FFFF 0CCC F000 0000"
    $"0F00 FAAA FFFF FFFF FFFF FFFF FF00 0000 0F00 0FFA AFFF FFBB"
    $"FF00 DDDD DF00 0000 0F00 00FF AAFF FFAB BF00 CCCC CF00 0000"
    $"0F00 00FF AAAB BFAA BBF0 0000 CF00 0000 0F00 00FF AABB BBFA"
    $"ABBF 0000 CF00 0000 0F00 00FF AABB FBBF AAAF 0000 CF00 0000"
    $"0F00 00FF AABB FBBB FFFF 0000 CF00 0000 0F00 00FF AAAB FBBB"
    $"BFBF 0000 CF00 0000 0F00 000F AA81 FBBB BFBF 0000 CF00 0000"
    $"0F00 000F 818A AFBB BFBF 0000 CF00 0000 0F00 00FF 8A8A AAFB"
    $"BFF0 0000 CF00 0000 0F00 00F8 AAAA AAFF FF00 0000 CF00 0000"
    $"0F00 00FF FFFF FFF0 0000 0000 CF00 0000 0F00 0000 0000 0000"
    $"0000 0000 CF00 0000 0F00 0000 0000 0000 0000 0000 CF00 0000"
    $"0F00 0000 0000 0000 0000 0000 CF00 0000 0F00 0000 0000 0000"
    $"0000 0000 CF00 0000 0F00 FF00 FF00 0000 0000 0000 CF00 0000"
    $"0F00 FF00 FF00 0000 0000 0000 CF00 0000 0F00 0000 0000 0000"
    $"0000 0000 CF00 0000 0F00 FF00 FF00 0000 0000 0000 CFE0 0000"
    $"0F00 FF00 FF00 0000 0000 0000 CFEE E000 0F00 0F00 0F00 0000"
    $"0000 0000 CFEE EEE0 0F00 F000 F000 0000 0000 0000 CFEE EEE0"
    $"0F00 0000 0000 0000 0000 0000 CFEE E000 0FFF FFFF FFFF FFFF"
    $"FFFF FFFF FFE0"
};

resource 'icl4' (1002) {
    $"FFFF FFFF FFFF FFFF FFFF FFFF F000 0000 F000 0000 0000 0000"
    $"0000 0000 F000 0000 F00F F00F F000 0000 0000 0000 FFF0 0000"
    $"F00F F00F F000 0000 0000 0000 FDF0 0000 F000 0000 0000 0000"
    $"0000 0000 FDF0 0000 F00F F00F F000 0000 0000 0000 FDF0 0000"
    $"F00F F00F F000 0000 0000 0000 FDF0 0000 F000 F000 F000 0000"
    $"0000 0000 FDF0 0000 F00F 000F 0000 0000 0000 0000 FDF0 0000"
    $"F000 0000 0000 0000 0000 0000 FDF0 0000 F000 0000 0000 0000"
    $"0000 0000 FDF0 0000 F000 0000 0000 0000 0000 0000 FDF0 0000"
    $"F000 0000 FFFF F000 0000 0000 FDF0 0000 F00F FFFF FBBB FFFF"
    $"FFF0 0000 FDF0 0000 F00F AAFF FFFF FFFF FFF0 0000 FDF0 0000"
    $"F00F AAAF FFFF FFFF FF00 0000 FDF0 0000 F000 FFAA FFFF FBBF"
    $"F000 0000 FDF0 0000 F000 0FFA AFFF FABB F000 0000 FDF0 0000"
    $"F000 0FFA AABB FAAB BF00 0000 FDF0 0000 F000 0FFA ABBB BFAA"
    $"BBF0 0000 FDF0 0000 F000 0FFA ABBF BBFA AAF0 0000 FDF0 0000"
    $"F000 0FFA ABBF BBBF FFF0 0000 FDF0 0000 F000 0FFA AABF BBBB"
    $"FBF0 0000 FDF0 0000 F000 00FA A81F BBBB FBFF FFFF FDF0 0000"
    $"F000 00F8 18AA FBBB FBFC CCCF DCF0 0000 F000 0FF8 A8AA AFBB"
    $"FFFC CCFD CCF0 0000 F000 0F8A AAAA AFFF F0FC CFDC CCFE 0000"
    $"F000 0FFF FFFF FF00 00FC FDCC CCFE EE00 F000 0000 0000 0000"
    $"00FF DCCC CCFE EEEE FFFF FFFF FFFF FFFF FFFD CCCC CCFE EEEE"
    $"00FD DDDD DDDD DDDD DDDC CCCC CCFE EE00 00FF FFFF FFFF FFFF"
    $"FFFF FFFF FFFE"
};

resource 'icl8' (1000) {
    $"0000 0000 0000 0000 0000 00FF FFFF FFFF FF00 0000 0000 0000"
    $"0000 0000 0000 0000 0000 0000 0000 0000 0000 FFFF FFFF FFFF"
    $"FFFF FF00 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000"
    $"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000 0000 0000 0000 0000"
    $"FFFF FFFF FFFF 00FF FFFF FFFF 0808 0808 0808 08FF FF00 0000"
    $"0000 FFFF FFFF FF00 FF33 3333 3333 FFFF FFFF 0808 0808 0808"
    $"0808 0808 08FF FFFF FFFF FFFF FFFF FF00 FF33 3333 3333 33FF"
    $"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
    $"FF33 3333 3333 3333 FFFF FFF9 F9F9 FFFF FFFF FFFF FFFF FFFF"
    $"FFFF FFFF FFFF 0000 FFFF 3333 3333 3333 33FF FFFF F6F6 FFFF"
    $"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000 00FF FF33 3333 3333"
    $"3333 FFFF FFF6 FFFF FFFF FFFF FF08 08FF FFFF FFFF FF00 0000"
    $"0000 FFFF FF33 3333 3333 33FF FFFF FFFF FFFF FFFF 0808 0808"
    $"FFFF FFFF 0000 0000 0000 0000 FFFF 3333 3333 3333 FFFF FFFF"
    $"FFFF FFFF 0808 0808 0808 FFFF 0000 0000 0000 0000 00FF FF33"
    $"3333 3333 33FF FFFF FFFF FF33 3308 0808 0808 08FF FF00 0000"
    $"0000 0000 00FF FF33 3333 3333 3308 0808 0808 FFFF 3333 0808"
    $"0808 0808 FFFF 0000 0000 0000 FFFF FF33 3333 3333 0808 0808"
    $"0808 08FF FF33 3308 0808 0808 08FF FF00 0000 0000 FFFF FF33"
    $"3333 3308 0808 0808 0808 0808 FFFF 3333 0808 0808 0808 FFFF"
    $"0000 0000 FFFF FF33 3333 3308 0808 0808 FFFF 0808 08FF FF33"
    $"3308 0808 0808 FFFF 0000 0000 FFFF FF33 3333 3308 0808 0808"
    $"FFFF 0808 0808 FFFF 3333 0833 0808 FFFF 0000 0000 FFFF FF33"
    $"3333 3308 0808 0808 FFFF 0808 0808 08FF FF33 3333 3333 FFFF"
    $"0000 0000 FFFF FF33 3333 3308 0808 0808 FFFF 0808 0808 0808"
    $"FFFF 3333 3333 FFFF 0000 0000 FFFF FF33 3333 3333 0808 0808"
    $"FFFF 0808 0808 0808 08FF FF33 33FF FFFF 0000 0000 FFFF FFFF"
    $"3333 3333 3308 0808 FFFF FF08 0808 0808 0808 FFFF 33FF 08FF"
    $"0000 0000 00FF FFFF 3333 3333 3333 0808 FFFF FF08 0808 0808"
    $"0808 08FF FFFF 08FF 0000 0000 0000 FFFF 3333 3333 3333 3305"
    $"E305 FF08 0808 0808 0808 08FF FF08 08FF 0000 0000 0000 00FF"
    $"3333 3333 33E3 0533 33FF FFFF 0808 0808 0808 08FF FF08 08FF"
    $"0000 0000 0000 00FF 3333 3305 E333 3333 33FF FFFF FF08 0808"
    $"0808 08FF FF08 08FF 0000 0000 0000 FFFF 33E3 0533 0533 3333"
    $"3333 33FF FFFF 0808 0808 08FF FF08 08FF 0000 0000 0000 FF33"
    $"0505 3333 E333 3333 3333 3333 FFFF FF08 0808 FFFF FF08 FF00"
    $"0000 0000 00FF FFE3 33E3 3333 3333 3333 3333 3333 33FF FFFF"
    $"08FF FFFF FF08 FF00 0000 0000 00FF E333 33E3 3333 3333 3333"
    $"3333 3333 3333 FFFF FFFF FFFF FFFF 0000 0000 0000 FFFF 3333"
    $"3333 3333 3333 3333 3333 3333 33FF FFFF FFFF FF00 0000 0000"
    $"0000 0000 FF33 3333 3333 3333 3333 3333 3333 3333 FFFF 0000"
    $"0000 0000 0000 0000 0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"
    $"FFFF FFFF FF"
};

resource 'icl8' (1001) {
    $"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
    $"0000 0000 0000 0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F5F5 F5FF FF00 0000 0000 0000 0000 0000 00FF F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF F8FF 0000 0000 0000 0000 0000"
    $"00FF F5F5 F5F5 F5F5 F5FF FFFF FFFF F5F5 F5F5 F5FF 00F8 FF00"
    $"0000 0000 0000 0000 00FF F5F5 FFFF FFFF FFFF 0808 08FF FFFF"
    $"FFFF FFFF 0000 F8FF 0000 0000 0000 0000 00FF F5F5 FF33 33FF"
    $"FFFF FFFF FFFF FFFF FFFF FFFF F5F6 F6F8 FF00 0000 0000 0000"
    $"00FF F5F5 FF33 3333 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
    $"FFFF 0000 0000 0000 00FF F5F5 F5FF FF33 33FF FFFF FFFF 0808"
    $"FFFF F5F5 F9F9 F9F9 F9FF 0000 0000 0000 00FF F5F5 F5F5 FFFF"
    $"3333 FFFF FFFF 3308 08FF F5F5 F7F7 F7F7 F7FF 0000 0000 0000"
    $"00FF F5F5 F5F5 FFFF 3333 3308 08FF 3333 0808 FFF5 F5F5 F5F5"
    $"F7FF 0000 0000 0000 00FF F5F5 F5F5 FFFF 3333 0808 0808 FF33"
    $"3308 08FF F5F5 F5F5 F7FF 0000 0000 0000 00FF F5F5 F5F5 FFFF"
    $"3333 0808 FF08 08FF 3333 33FF F5F5 F5F5 F7FF 0000 0000 0000"
    $"00FF F5F5 F5F5 FFFF 3333 0808 FF08 0808 FFFF FFFF F5F5 F5F5"
    $"F7FF 0000 0000 0000 00FF F5F5 F5F5 FFFF 3333 3308 FF08 0808"
    $"08FF 08FF F5F5 F5F5 F7FF 0000 0000 0000 00FF F5F5 F5F5 F5FF"
    $"3333 E305 FF08 0808 08FF 08FF F5F5 F5F5 F7FF 0000 0000 0000"
    $"00FF F5F5 F5F5 F5FF E305 E333 33FF 0808 08FF 08FF F5F5 F5F5"
    $"F7FF 0000 0000 0000 00FF F5F5 F5F5 FFFF E333 E333 3333 FF08"
    $"08FF FFF5 F5F5 F5F5 F7FF 0000 0000 0000 00FF F5F5 F5F5 FFE3"
    $"3333 3333 3333 FFFF FFFF F5F5 F5F5 F5F5 F7FF 0000 0000 0000"
    $"00FF F5F5 F5F5 FFFF FFFF FFFF FFFF FFF5 F5F5 F5F5 F5F5 F5F5"
    $"F7FF 0000 0000 0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 F7FF 0000 0000 0000 00FF F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F7FF 0000 0000 0000"
    $"00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F7FF 0000 0000 0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 F7FF 0000 0000 0000 00FF F5F5 FFFF F5F5"
    $"FFFF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F7FF 0000 0000 0000"
    $"00FF F5F5 FFFF F5F5 FFFF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F7FF 0000 0000 0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 F7FF 0000 0000 0000 00FF F5F5 FFFF F5F5"
    $"FFFF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F7FF FC00 0000 0000"
    $"00FF F5F5 FFFF F5F5 FFFF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F7FF FCFC FC00 0000 00FF F5F5 F5FF F5F5 F5FF F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 F7FF FCFC FCFC FC00 00FF F5F5 FFF5 F5F5"
    $"FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F7FF FCFC FCFC FC00"
    $"00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F7FF FCFC FC00 0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
    $"FFFF FFFF FFFF FFFF FFFF FC"
};

resource 'icl8' (1002) {
    $"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
    $"FF00 0000 0000 0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 FF00 0000 0000 0000 FFF5 F5FF FFF5 F5FF"
    $"FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 FFFF FF00 0000 0000"
    $"FFF5 F5FF FFF5 F5FF FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"FFF9 FF00 0000 0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 FFF9 FF00 0000 0000 FFF5 F5FF FFF5 F5FF"
    $"FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 FFF9 FF00 0000 0000"
    $"FFF5 F5FF FFF5 F5FF FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"FFF9 FF00 0000 0000 FFF5 F5F5 FFF5 F5F5 FFF5 F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 FFF9 FF00 0000 0000 FFF5 F5FF F5F5 F5FF"
    $"F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 FFF9 FF00 0000 0000"
    $"FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"FFF9 FF00 0000 0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 FFF9 FF00 0000 0000 FFF5 F5F5 F5F5 F5F5"
    $"F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 FFF9 FF00 0000 0000"
    $"FFF5 F5F5 F5F5 F5F5 FFFF FFFF FFF5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"FFF9 FF00 0000 0000 FFF5 F5FF FFFF FFFF FF08 0808 FFFF FFFF"
    $"FFFF FFF5 F5F5 F5F5 FFF9 FF00 0000 0000 FFF5 F5FF 3333 FFFF"
    $"FFFF FFFF FFFF FFFF FFFF FFF5 F5F5 F5F5 FFF9 FF00 0000 0000"
    $"FFF5 F5FF 3333 33FF FFFF FFFF FFFF FFFF FFFF F5F5 F5F5 F5F5"
    $"FFF9 FF00 0000 0000 FFF5 F5F5 FFFF 3333 FFFF FFFF FF08 08FF"
    $"FFF5 F5F5 F5F5 F5F5 FFF9 FF00 0000 0000 FFF5 F5F5 F5FF FF33"
    $"33FF FFFF FF33 0808 FFF5 F5F5 F5F5 F5F5 FFF9 FF00 0000 0000"
    $"FFF5 F5F5 F5FF FF33 3333 0808 FF33 3308 08FF F5F5 F5F5 F5F5"
    $"FFF9 FF00 0000 0000 FFF5 F5F5 F5FF FF33 3308 0808 08FF 3333"
    $"0808 FFF5 F5F5 F5F5 FFF9 FF00 0000 0000 FFF5 F5F5 F5FF FF33"
    $"3308 08FF 0808 FF33 3333 FFF5 F5F5 F5F5 FFF9 FF00 0000 0000"
    $"FFF5 F5F5 F5FF FF33 3308 08FF 0808 08FF FFFF FFF5 F5F5 F5F5"
    $"FFF9 FF00 0000 0000 FFF5 F5F5 F5FF FF33 3333 08FF 0808 0808"
    $"FF08 FFF5 F5F5 F5F5 FFF9 FF00 0000 0000 FFF5 F5F5 F5F5 FF33"
    $"33E3 05FF 0808 0808 FF08 FFFF FFFF FFFF FFF9 FF00 0000 0000"
    $"FFF5 F5F5 F5F5 FFE3 05E3 3333 FF08 0808 FF08 FF2B 2B2B F7FF"
    $"F9F7 FF00 0000 0000 FFF5 F5F5 F5FF FFE3 33E3 3333 33FF 0808"
    $"FFFF FF2B 2BF7 FFF9 F72B FF00 0000 0000 FFF5 F5F5 F5FF E333"
    $"3333 3333 33FF FFFF FFF5 FF2B F7FF F9F7 2BF6 FFFC 0000 0000"
    $"FFF5 F5F5 F5FF FFFF FFFF FFFF FFFF F5F5 F5F5 FFF7 FFF9 F72B"
    $"F6F6 FFFC FCFC 0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
    $"F5F5 FFFF F9F7 2BF6 F6F6 FFFC FCFC FCFC FFFF FFFF FFFF FFFF"
    $"FFFF FFFF FFFF FFFF FFFF FFF9 F72B F6F6 F6F6 FFFC FCFC FCFC"
    $"0000 FFF9 F9F9 F9F9 F9F9 F9F9 F9F9 F9F9 F9F9 F9F7 2BF6 F6F6"
    $"F6F6 FFFC FCFC 0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
    $"FFFF FFFF FFFF FFFF FFFF FFFC"
};

resource 'ICN#' (1000) {
    {   /* array: 2 elements */
        /* [1] */
        $"001F 8000 003F E000 00FF F000 FDF0 183E 83C0 07FE 81FF FFFE"
        $"80E3 FFFC C073 FFFC 603B F9F8 381F F0F0 0C0F F030 0607 E018"
        $"0600 300C 0E00 1806 0E00 0C03 0E00 C603 0E00 C303 0E00 C183"
        $"0E00 C0C3 0E00 C067 0F00 E035 0700 E01D 0301 E019 0106 7019"
        $"0118 7819 0368 1C19 02C8 0E3A 0740 077A 0640 03FC 0C00 07E0"
        $"0800 0C00 0F7F F8",
        /* [2] */
        $"001F 8000 003F E000 00FF F000 FDFF F83E FFFF FFFE FFFF FFFE"
        $"FFFF FFFC FFFF FFFC 7FFF FFF8 3FFF FFF0 0FFF FFF0 07FF FFF8"
        $"07FF FFFC 0FFF FFFE 0FFF FFFF 0FFF FFFF 0FFF FFFF 0FFF FFFF"
        $"0FFF FFFF 0FFF FFFF 0FFF FFFF 07FF FFFF 03FF FFFF 01FF FFFF"
        $"01FF FFFF 03FF FFFF 03FF FFFE 07FF FFFE 07FF FFFC 0FFF FFE0"
        $"0FFF FC00 0FFF F8"
    }
};

resource 'ICN#' (1001) {
    {   /* array: 2 elements */
        /* [1] */
        $"7FFF F000 4000 1800 4000 1400 407C 1200 4FC7 F100 49FF F080"
        $"48FF FFC0 467C C040 433C 4040 4304 2040 4302 1040 4309 1040"
        $"4308 F040 4308 5040 4138 5040 41E4 5040 43A2 6040 4203 C040"
        $"43FE 0040 4000 0040 4000 0040 4000 0040 4000 0040 4CC0 0040"
        $"4CC0 0040 4000 0040 4CC0 0060 4CC0 0078 4440 007E 4880 007E"
        $"4000 0078 7FFF FFE0",
        /* [2] */
        $"7FFF F000 7FFF F800 7FFF FC00 7FFF FE00 7FFF FF00 7FFF FF80"
        $"7FFF FFC0 7FFF FFC0 7FFF FFC0 7FFF FFC0 7FFF FFC0 7FFF FFC0"
        $"7FFF FFC0 7FFF FFC0 7FFF FFC0 7FFF FFC0 7FFF FFC0 7FFF FFC0"
        $"7FFF FFC0 7FFF FFC0 7FFF FFC0 7FFF FFC0 7FFF FFC0 7FFF FFC0"
        $"7FFF FFC0 7FFF FFC0 7FFF FFE0 7FFF FFF8 7FFF FFFE 7FFF FFFE"
        $"7FFF FFF8 7FFF FFE0"
    }
};

resource 'ICN#' (1002) {
    {   /* array: 2 elements */
        /* [1] */
        $"FFFF FF80 8000 0080 9980 00E0 9980 00A0 8000 00A0 9980 00A0"
        $"9980 00A0 8880 00A0 9100 00A0 8000 00A0 8000 00A0 8000 00A0"
        $"80F8 00A0 9F8F E0A0 93FF E0A0 91FF C0A0 8CF9 80A0 8678 80A0"
        $"8608 40A0 8604 20A0 8612 20A0 8611 E0A0 8610 A0A0 8270 BFA0"
        $"83C8 A120 8744 E220 8407 A430 87FC 283C 8000 303F FFFF E03F"
        $"2000 003C 3FFF FFF0",
        /* [2] */
        $"FFFF FF80 FFFF FF80 FFFF FFE0 FFFF FFE0 FFFF FFE0 FFFF FFE0"
        $"FFFF FFE0 FFFF FFE0 FFFF FFE0 FFFF FFE0 FFFF FFE0 FFFF FFE0"
        $"FFFF FFE0 FFFF FFE0 FFFF FFE0 FFFF FFE0 FFFF FFE0 FFFF FFE0"
        $"FFFF FFE0 FFFF FFE0 FFFF FFE0 FFFF FFE0 FFFF FFE0 FFFF FFE0"
        $"FFFF FFE0 FFFF FFE0 FFFF FFF0 FFFF FFFC FFFF FFFF FFFF FFFF"
        $"3FFF FFFC 3FFF FFF0"
    }
};

resource 'ics#' (1000) {
    {   /* array: 2 elements */
        /* [1] */
        $"07C0 FC7F 9FFF 8FFE 67CC 33C4 3042 3021 3091 308F 3085 1385"
        $"1E45 3A26 203C 3FE0",
        /* [2] */
        $"07C0 FFFF FFFF FFFE 7FFC 3FFC 3FFE 3FFF 3FFF 3FFF 3FFF 1FFF"
        $"1FFF 3FFE 3FFC 3FE0"
    }
};

resource 'ics#' (1001) {
    {   /* array: 2 elements */
        /* [1] */
        $"FFE0 8070 8058 8078 8008 8008 8008 B608 B608 8008 B608 B608"
        $"9208 A40E 800F FFFE",
        /* [2] */
        $"FFE0 FFF0 FFF8 FFF8 FFF8 FFF8 FFF8 FFF8 FFF8 FFF8 FFF8 FFF8"
        $"FFF8 FFFE FFFF FFFE"
    }
};

resource 'ics#' (1002) {
    {   /* array: 2 elements */
        /* [1] */
        $"FFF8 800C B60C B60C 800C B60C B60C 920C A40C 800C 800C 807C"
        $"8054 8066 FFC7 7FFE",
        /* [2] */
        $"FFF8 FFFC FFFC FFFC FFFC FFFC FFFC FFFC FFFC FFFC FFFC FFFC"
        $"FFFC FFFE FFFF 7FFE"
    }
};

resource 'ics4' (1000) {
    $"0000 0FFF FF00 0000 FFFF FFBB BFFF FFFF FAAF FFFF FFFF FFFF"
    $"FAAA FFFF FFFF FFF0 0FFA AFFF FFBB FF00 00FF AAFF FFAB BF00"
    $"00FF AAAB BFAA BBF0 00FF AABB BBFA ABBF 00FF AABB FBBF AAAF"
    $"00FF AABB FBBB FFFF 00FF AAAB FBBB BFBF 000F AA81 FBBB BFBF"
    $"000F 818A AFBB BFBF 00FF 8A8A AAFB BFF0 00F8 AAAA AAFF FF00"
    $"00FF FFFF FFF0"
};

resource 'ics4' (1001) {
    $"FFFF FFFF FFF0 0000 F000 0000 0FFF 0000 F000 0000 0FCF F000"
    $"F000 0000 0FFF F000 F000 0000 00CC F000 F000 0000 000C F000"
    $"F000 0000 000C F000 F0FF 0FF0 000C F000 F0FF 0FF0 000C F000"
    $"F000 0000 000C F000 F0FF 0FF0 000C F000 F0FF 0FF0 000C F000"
    $"F00F 00F0 000C F000 F0F0 0F00 000C FEE0 F000 0000 000C FEEE"
    $"FFFF FFFF FFFF FEE0"
};

resource 'ics4' (1002) {
    $"FFFF FFFF FFFF F000 F000 0000 0000 FF00 F0FF 0FF0 0000 FF00"
    $"F0FF 0FF0 0000 FF00 F000 0000 0000 FF00 F0FF 0FF0 0000 FF00"
    $"F0FF 0FF0 0000 FF00 F00F 00F0 0000 FF00 F0F0 0F00 0000 FF00"
    $"F000 0000 0000 FF00 F000 0000 0000 FF00 F000 0000 0FFF FF00"
    $"F000 0000 0FCF DF00 F000 0000 0FFD CFE0 FFFF FFFF FFDC CFEE"
    $"0FFF FFFF FFFF FFE0"
};

resource 'ics8' (1000) {
    $"0000 0000 00FF FFFF FFFF 0000 0000 0000 FFFF FFFF FFFF 0808"
    $"08FF FFFF FFFF FFFF FF33 33FF FFFF FFFF FFFF FFFF FFFF FFFF"
    $"FF33 3333 FFFF FFFF FFFF FFFF FFFF FF00 00FF FF33 33FF FFFF"
    $"FFFF 0808 FFFF 0000 0000 FFFF 3333 FFFF FFFF 3308 08FF 0000"
    $"0000 FFFF 3333 3308 08FF 3333 0808 FF00 0000 FFFF 3333 0808"
    $"0808 FF33 3308 08FF 0000 FFFF 3333 0808 FF08 08FF 3333 33FF"
    $"0000 FFFF 3333 0808 FF08 0808 FFFF FFFF 0000 FFFF 3333 3308"
    $"FF08 0808 08FF 08FF 0000 00FF 3333 E305 FF08 0808 08FF 08FF"
    $"0000 00FF E305 E333 33FF 0808 08FF 08FF 0000 FFFF E333 E333"
    $"3333 FF08 08FF FF00 0000 FFE3 3333 3333 3333 FFFF FFFF 0000"
    $"0000 FFFF FFFF FFFF FFFF FF"
};

resource 'ics8' (1001) {
    $"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000 FFF5 F5F5 F5F5 F5F5"
    $"F5FF FFFF 0000 0000 FFF5 F5F5 F5F5 F5F5 F5FF F6FF FF00 0000"
    $"FFF5 F5F5 F5F5 F5F5 F5FF FFFF FF00 0000 FFF5 F5F5 F5F5 F5F5"
    $"F5F5 F7F7 FF00 0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F7 FF00 0000"
    $"FFF5 F5F5 F5F5 F5F5 F5F5 F5F7 FF00 0000 FFF5 FFFF F5FF FFF5"
    $"F5F5 F5F7 FF00 0000 FFF5 FFFF F5FF FFF5 F5F5 F5F7 FF00 0000"
    $"FFF5 F5F5 F5F5 F5F5 F5F5 F5F7 FF00 0000 FFF5 FFFF F5FF FFF5"
    $"F5F5 F5F7 FF00 0000 FFF5 FFFF F5FF FFF5 F5F5 F5F7 FF00 0000"
    $"FFF5 F5FF F5F5 FFF5 F5F5 F5F7 FF00 0000 FFF5 FFF5 F5FF F5F5"
    $"F5F5 F5F7 FFFC FC00 FFF5 F5F5 F5F5 F5F5 F5F5 F5F7 FFFC FCFC"
    $"FFFF FFFF FFFF FFFF FFFF FFFF FFFC FC"
};

resource 'ics8' (1002) {
    $"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000 FFF5 F5F5 F5F5 F500"
    $"F5F5 F5F5 FFFF 0000 FFF5 FFFF F5FF FF00 F5F5 F5F5 FFFF 0000"
    $"FFF5 FFFF F5FF FF00 F5F5 F5F5 FFFF 0000 FFF5 F5F5 F5F5 F500"
    $"F5F5 F5F5 FFFF 0000 FFF5 FFFF F5FF FF00 F5F5 F5F5 FFFF 0000"
    $"FFF5 FFFF F5FF FF00 F5F5 F5F5 FFFF 0000 FFF5 F5FF F5F5 FF00"
    $"F5F5 F5F5 FFFF 0000 FFF5 FFF5 F5FF F500 F5F5 F5F5 FFFF 0000"
    $"FFF5 F5F5 F5F5 F500 F5F5 F5F5 FFFF 0000 FFF5 F5F5 F5F5 F5F5"
    $"F5F5 F5F5 FFFF 0000 FFF5 F5F5 F5F5 F5F5 F5FF FFFF FFFF 0000"
    $"FFF5 F5F5 F5F5 F5F5 F5FF F5FF F9FF 0000 FFF5 F5F5 F5F5 F5F5"
    $"F5FF FFF9 F7FF FC00 FFFF FFFF FFFF FFFF FFFF F9F7 F7FF FCFC"
    $"00FF FFFF FFFF FFFF FFFF FFFF FFFF FC"
};

resource 'ICON' (1000) {
    $"001F 8000 003F E000 00FF F000 FDF0 183E 83C0 07FE 81FF FFFE"
    $"80E3 FFFC C073 FFFC 603B F9F8 381F F0F0 0C0F F030 0607 E018"
    $"0600 300C 0E00 1806 0E00 0C03 0E00 C603 0E00 C303 0E00 C183"
    $"0E00 C0C3 0E00 C067 0F00 E035 0700 E01D 0301 E019 0106 7019"
    $"0118 7819 0368 1C19 02C8 0E3A 0740 077A 0640 03FC 0C00 07E0"
    $"0800 0C00 0FFF F8"
};

data 'cicn' (1000) {
    $"0000 0000 8010 0000 0000 0020 0020 0000 0000 0000 0000 0048"
    $"0000 0048 0000 0000 0004 0001 0004 0000 0000 0000 0000 0000"
    $"0000 0000 0000 0004 0000 0000 0020 0020 0000 0000 0004 0000"
    $"0000 0020 0020 0000 0000 001F 8000 003F E000 00FF F000 FDFF"
    $"F83E FFFF FFFE FFFF FFFE FFFF FFFC FFFF FFFC 7FFF FFF8 3FFF"
    $"FFF0 0FFF FFF0 07FF FFF8 07FF FFFC 0FFF FFFE 0FFF FFFF 0FFF"
    $"FFFF 0FFF FFFF 0FFF FFFF 0FFF FFFF 0FFF FFFF 0FFF FFFF 07FF"
    $"FFFF 03FF FFFF 01FF FFFF 01FF FFFF 03FF FFFF 03FF FFFE 07FF"
    $"FFFE 07FF FFFC 0FFF FFE0 0FFF FC00 0FFF F800 001F 8000 003F"
    $"E000 00FF F000 FDF0 183E 83C0 07FE 81FF FFFE 80E3 FFFC C073"
    $"FFFC 603B F9F8 381F F0F0 0C0F F030 0607 E018 0600 300C 0E00"
    $"1806 0E00 0C03 0E00 C603 0E00 C303 0E00 C183 0E00 C0C3 0E00"
    $"C067 0F00 E035 0700 E01D 0301 E019 0106 7019 0118 7819 0368"
    $"1C19 02C8 0E3A 0740 077A 0640 03FC 0C00 07E0 0800 0C00 0FFF"
    $"F800 0000 0000 0000 0007 0000 FFFF FFFF FFFF 0001 FFFF FFFF"
    $"0000 0002 CCCC 9999 6666 0003 8888 8888 8888 0004 DDDD DDDD"
    $"DDDD 0005 FFFF CCCC 9999 0006 0000 BBBB 0000 000F 0000 0000"
    $"0000 0000 0000 000F FFFF F000 0000 0000 0000 0000 0000 00FF"
    $"FFFF FFF0 0000 0000 0000 0000 0000 FFFF FFFF FFFF 0000 0000"
    $"0000 FFFF FF0F FFFF 5555 555F F000 00FF FFF0 F222 22FF FF55"
    $"5555 5555 5FFF FFFF FFF0 F222 222F FFFF FFFF FFFF FFFF FFFF"
    $"FFF0 F222 2222 FFF3 33FF FFFF FFFF FFFF FF00 FF22 2222 2FFF"
    $"44FF FFFF FFFF FFFF FF00 0FF2 2222 22FF F4FF FFFF F55F FFFF"
    $"F000 00FF F222 222F FFFF FFFF 5555 FFFF 0000 0000 FF22 2222"
    $"FFFF FFFF 5555 55FF 0000 0000 0FF2 2222 2FFF FFF2 2555 555F"
    $"F000 0000 0FF2 2222 2555 55FF 2255 5555 FF00 0000 FFF2 2222"
    $"5555 555F F225 5555 5FF0 0000 FFF2 2225 5555 5555 FF22 5555"
    $"55FF 0000 FFF2 2225 5555 FF55 5FF2 2555 55FF 0000 FFF2 2225"
    $"5555 FF55 55FF 2252 55FF 0000 FFF2 2225 5555 FF55 555F F222"
    $"22FF 0000 FFF2 2225 5555 FF55 5555 FF22 22FF 0000 FFF2 2222"
    $"5555 FF55 5555 5FF2 2FFF 0000 FFFF 2222 2555 FFF5 5555 55FF"
    $"2F5F 0000 0FFF 2222 2255 FFF5 5555 555F FF5F 0000 00FF 2222"
    $"2221 61F5 5555 555F F55F 0000 000F 2222 2612 2FFF 5555 555F"
    $"F55F 0000 000F 2221 6222 2FFF F555 555F F55F 0000 00FF 2612"
    $"1222 222F FF55 555F F55F 0000 00F2 1122 6222 2222 FFF5 55FF"
    $"F5F0 0000 0FF6 2622 2222 2222 2FFF 5FFF F5F0 0000 0F62 2622"
    $"2222 2222 22FF FFFF FF00 0000 FF22 2222 2222 2222 2FFF FFF0"
    $"0000 0000 F222 2222 2222 2222 FF00 0000 0000 0000 FFFF FFFF"
    $"FFFF FFFF F000 0000 0000"
};
