// Copyright (C) 2003 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#ifndef AXES_H
#define AXES_H

#include <stdio.h>
#include <string>
#include <stack>
#include <vector>
#include "globals.h"
#include "object.h"
#include "op_com.h"
#include "ticks.h"

class Axes : public Object {
public:
  //! sets up all properties
  Axes(ocpl::Handle Parent);
  //! does nothing
  ~Axes();
  virtual void Parse(ocpl::command& com);
  virtual void SetPrinting(bool set);
  virtual void PostSet(ocpl::command& com);

  //! screen pixel to axes coordinates
  void GetCoords(const ocpl::Real screen_x, const ocpl::Real screen_y,
		 ocpl::Real& axis_x, ocpl::Real& axis_y);

  //! size of a screen pixel in axes coordinates
  void GetPixel(ocpl::Real& dx, ocpl::Real& dy);
  //! Sets the x-y axes limits 
  void SetLimits(ocpl::Real x1,ocpl::Real y1,ocpl::Real x2,ocpl::Real y2);
  //! Sets up limits if they are automatic
  void AutoScale();
  //! Sets up ticks, ticklabels, axeslabels & title
  void AutoTicks();
  ocpl::Real PlotRound(ocpl::Real );
  
  int depth_zoomstack() {return zoomstack.size();};
  void push_zoombox();
  void pop_zoombox();

private:

  // holds zoombx for the zoomstack
  struct zoombox {
    zoombox(double _x1,
	    double _y1,
	    double _x2,
	    double _y2) : x1(_x1),x2(_x2),y1(_y1),y2(_y2) {};
    double x1,x2,y1,y2;
  };
  std::stack<zoombox> zoomstack;

  void draw();

  // helper functions start here

  enum axis_name {x_axis,y_axis,z_axis} ;
  int  numticks;

  //! Sets up the linear coordinates limits below
  void SetupLimits();
  double xlimits[2],ylimits[2],zlimits[2];
  //! Resets the axes
  void Reset();
  //! sets up one axis autoscale, called by AutoScale
  bool AutoScaleAxis(int na, double* lim);
  //! sets up one axes ticks, called by AutoTicks
  void AutoTicksAxis(Matrix& lim,Matrix& tick,bool log, int direction, double pixelSize);
  //! Draws one axis (bar & ticks), called by draw
  void DrawOneAxis(axis_name ax,Matrix& ticks,
		   double* lim, double* lim_o,double ddo,
		   bool log , bool logo, bool box);

  //! extracts label i from "a|b|c" string
  std::string GetTickLabel(String& labels, int pos);
  //! formats tick positions into a "a|b|c|d" string
  void TickLabels(Matrix& tick, String& label);	


  //! printing helper function
  void __setprinting(HandleVect& hv,bool set);

  //! Automatic ticks calculators
  Ticks **auto_tickers;
};

#endif
