// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  


#include "prop_color_radio.h"

bool ColorRadio::SetColor()
{
  if(!IsRadio) {
    glColor4dv(rgba);
    return true;
  }

  return false;
}

void ColorRadio::Get(ocpl::command& com)
{
  if(!IsRadio) {
    Color::Get(com);
  }
  else {
    Radio::Get(com);
  }
}

void ColorRadio::Set(ocpl::command& com)
{
  IsRadio = false;
  if(com.argin(2)->id==ocpl::str) {
    const char* tmpstr = com.argin(2)->str_data();
    if(strlen(tmpstr)==1) // have single char color!
      Color::Set(com);
    else {
      IsRadio = true;
      Radio::Set(com);
    }
  }
  else
    Color::Set(com);
}
