// Copyright (C) 2003 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#ifndef PROPERTY_H
#define PROPERTY_H

class Property;

#include "op_com.h"
#include "globals.h"

class Property {
public: 
  Property() : ro(false), _pre_set(0) , _post_set(0) {};
  virtual ~Property() {};
  virtual void Get(ocpl::command& com) = 0;
  virtual void Set(ocpl::command& com) = 0;
  void SetPreSet(bool (*prs)(ocpl::command& com, Property *caller)) {_pre_set=prs;}
  void SetPostSet(bool (*pos)(ocpl::command& com, Property *caller)) {_post_set=pos;}
  void CallPreSet(ocpl::command& com) {if(_pre_set) (*_pre_set)(com,this);}
  void CallPostSet(ocpl::command& com) {if(_post_set) (*_post_set)(com,this);}
  bool readonly() {return ro;}
  void readonly(bool _ro) {ro=_ro;}
private:
  bool ro;
  bool (*_pre_set)(ocpl::command& com, Property *caller);
  bool (*_post_set)(ocpl::command& com, Property *caller);
};

// include all property classes
#include "prop_bool.h"
#include "prop_color_radio.h"
#include "prop_handle.h"
#include "prop_matrix.h"
#include "prop_scalar.h"
#include "prop_string.h"

#endif

