SUBROUTINE F_ODB_ADDVIEW(HANDLE, NAME, VHANDLE)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
USE ODB_MODULE, ONLY : ODB_ADDVIEW
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE
CHARACTER(LEN=*), INTENT(IN)    :: NAME
INTEGER(KIND=JPIM), INTENT(OUT) :: VHANDLE
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_ADDVIEW',0,ZHOOK_HANDLE)
VHANDLE = ODB_ADDVIEW(HANDLE, NAME, ABORT=.FALSE.)
IF (LHOOK) CALL DR_HOOK('F_ODB_ADDVIEW',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_ADDVIEW

SUBROUTINE F_ODB_CANCEL(HANDLE, NAME, POOLNO, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
USE ODB_MODULE, ONLY : ODB_CANCEL
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE, POOLNO
CHARACTER(LEN=*), INTENT(IN)    :: NAME
INTEGER(KIND=JPIM), INTENT(OUT) :: RC
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_CANCEL',0,ZHOOK_HANDLE)
RC = ODB_CANCEL(HANDLE, NAME, POOLNO=POOLNO)
IF (LHOOK) CALL DR_HOOK('F_ODB_CANCEL',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_CANCEL

SUBROUTINE F_ODB_COPYDATA(TO, NCHUNK, NOFFSET, FROM, NROWS, NCOLS, NRA, SWAPBYTES, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: NCHUNK, NOFFSET, NROWS, NCOLS, NRA, SWAPBYTES
REAL(KIND=JPRB), INTENT(OUT)    :: TO(NCOLS, NCHUNK)
REAL(KIND=JPRB), INTENT(IN)     :: FROM(NRA,0:NCOLS)
INTEGER(KIND=JPIM), INTENT(OUT) :: RC
INTEGER :: JROW, JCOL
LOGICAL :: LLSWAPBYTES 
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_COPYDATA',0,ZHOOK_HANDLE)
LLSWAPBYTES = (SWAPBYTES == 1)
DO JCOL=1,NCOLS
  DO JROW=NOFFSET+1,NOFFSET+NCHUNK
    TO(JCOL,JROW-NOFFSET) = FROM(JROW,JCOL)
  ENDDO
ENDDO
IF (LLSWAPBYTES) CALL SWAP8BYTES(TO, NCOLS * NCHUNK)
RC = NCHUNK
IF (LHOOK) CALL DR_HOOK('F_ODB_COPYDATA',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_COPYDATA

SUBROUTINE F_ODB_CLOSE(HANDLE, SAVE, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
USE ODB_MODULE, ONLY : ODB_CLOSE
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE, SAVE
INTEGER(KIND=JPIM), INTENT(OUT) :: RC
LOGICAL :: LLSAVE
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_CLOSE',0,ZHOOK_HANDLE)
LLSAVE = (SAVE == 1)
RC = ODB_CLOSE(HANDLE, SAVE=LLSAVE)
IF (LHOOK) CALL DR_HOOK('F_ODB_CLOSE',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_CLOSE

SUBROUTINE F_ODB_GET(HANDLE, NAME, A, NROWS, NCOLS, NRA, POOLNO, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
USE ODB_MODULE, ONLY : ODB_GET
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)    :: HANDLE, POOLNO, NRA
CHARACTER(LEN=*), INTENT(IN)      :: NAME
INTEGER(KIND=JPIM), INTENT(INOUT) :: NROWS, NCOLS
REAL(KIND=JPRB), INTENT(OUT)      :: A(NRA,0:NCOLS)
INTEGER(KIND=JPIM), INTENT(OUT)   :: RC
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_GET',0,ZHOOK_HANDLE)
RC = ODB_GET(HANDLE, NAME, A, NROWS, NCOLS=NCOLS, POOLNO=POOLNO)
IF (LHOOK) CALL DR_HOOK('F_ODB_GET',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_GET

SUBROUTINE F_ODB_OPEN(DBNAME, MODE, NPOOLS, HANDLE)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
USE ODB_MODULE, ONLY : ODB_OPEN
IMPLICIT NONE
CHARACTER(LEN=*), INTENT(IN)      :: DBNAME, MODE
INTEGER(KIND=JPIM), INTENT(INOUT) :: NPOOLS
INTEGER(KIND=JPIM), INTENT(OUT)   :: HANDLE
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_OPEN',0,ZHOOK_HANDLE)
HANDLE = ODB_OPEN(DBNAME,MODE,NPOOLS)
IF (LHOOK) CALL DR_HOOK('F_ODB_OPEN',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_OPEN

SUBROUTINE F_ODB_RELEASE(HANDLE, POOLNO, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
USE ODB_MODULE, ONLY : ODB_RELEASE
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE, POOLNO
INTEGER(KIND=JPIM), INTENT(OUT) :: RC
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_RELEASE',0,ZHOOK_HANDLE)
RC = ODB_RELEASE(HANDLE, POOLNO=POOLNO)
IF (LHOOK) CALL DR_HOOK('F_ODB_RELEASE',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_RELEASE

SUBROUTINE F_ODB_SELECT(HANDLE, NAME, NROWS, NCOLS, NRA, POOLNO, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
USE ODB_MODULE, ONLY : ODB_SELECT
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE, POOLNO
CHARACTER(LEN=*)  , INTENT(IN)  :: NAME
INTEGER(KIND=JPIM), INTENT(OUT) :: NROWS, NCOLS, NRA, RC
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_SELECT',0,ZHOOK_HANDLE)
RC = ODB_SELECT(HANDLE, NAME, NROWS, NCOLS, NRA=NRA, POOLNO=POOLNO)
IF (LHOOK) CALL DR_HOOK('F_ODB_SELECT',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_SELECT

SUBROUTINE F_ODB_GET_TABLENAMES(HANDLE, CHTBL, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE
CHARACTER(LEN=*), INTENT(OUT)   :: CHTBL
INTEGER(KIND=JPIM), INTENT(OUT) :: RC
INTEGER(KIND=JPIM), PARAMETER   :: JPWHAT = 3
INTEGER(KIND=JPIM)              :: ILOC
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_GET_TABLENAMES',0,ZHOOK_HANDLE)
CHTBL = ' '
CALL cODB_getnames(HANDLE, '*', JPWHAT, CHTBL, ILOC, RC)
!ILOC = SCAN(CHTBL,'/',back=.TRUE.)
IF (ILOC > 0 .AND. ILOC < LEN(CHTBL)) THEN
!  CHTBL(ILOC+1:) = ' '
  CHTBL(ILOC+1:ILOC+1) = char(0)
ENDIF
IF (LHOOK) CALL DR_HOOK('F_ODB_GET_TABLENAMES',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_GET_TABLENAMES

SUBROUTINE F_ODB_GET_COLNAMES(HANDLE, NAME, CHTBL, EXTNAME, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE, EXTNAME
CHARACTER(LEN=*), INTENT(IN)    :: NAME
CHARACTER(LEN=*), INTENT(OUT)   :: CHTBL
INTEGER(KIND=JPIM), INTENT(OUT) :: RC
INTEGER(KIND=JPIM), PARAMETER   :: JPWHAT = 2
INTEGER(KIND=JPIM)              :: ILOC, IWHAT
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_GET_COLNAMES',0,ZHOOK_HANDLE)
CHTBL = ' '
IWHAT = JPWHAT
IF (EXTNAME == 1) IWHAT = IWHAT + 100
CALL cODB_getnames(HANDLE, NAME, IWHAT, CHTBL, ILOC, RC)
!ILOC = SCAN(CHTBL,'/',back=.TRUE.)
IF (ILOC > 0 .AND. ILOC < LEN(CHTBL)) THEN
!  CHTBL(ILOC+1:) = ' '
  CHTBL(ILOC+1:ILOC+1) = char(0)
ENDIF
IF (LHOOK) CALL DR_HOOK('F_ODB_GET_COLNAMES',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_GET_COLNAMES

SUBROUTINE F_ODB_GET_TYPENAMES(HANDLE, NAME, CHTBL, EXTNAME, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE, EXTNAME
CHARACTER(LEN=*), INTENT(IN)    :: NAME
CHARACTER(LEN=*), INTENT(OUT)   :: CHTBL
INTEGER(KIND=JPIM), INTENT(OUT) :: RC
INTEGER(KIND=JPIM), PARAMETER   :: JPWHAT = 1
INTEGER(KIND=JPIM)              :: ILOC, IWHAT
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_GET_TYPENAMES',0,ZHOOK_HANDLE)
CHTBL = ' '
IWHAT = JPWHAT
IF (EXTNAME == 1) IWHAT = IWHAT + 100
CALL cODB_getnames(HANDLE, NAME, IWHAT, CHTBL, ILOC, RC)
!ILOC = SCAN(CHTBL,'/',back=.TRUE.)
IF (ILOC > 0 .AND. ILOC < LEN(CHTBL)) THEN
!  CHTBL(ILOC+1:) = ' '
  CHTBL(ILOC+1:ILOC+1) = char(0)
ENDIF
IF (LHOOK) CALL DR_HOOK('F_ODB_GET_TYPENAMES',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_GET_TYPENAMES

SUBROUTINE F_ODB_SETVAL(HANDLE, NAME, VARNAME, NEWVALUE, OLDVALUE)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
USE ODB_MODULE, ONLY : ODB_SETVAL
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE
CHARACTER(LEN=*), INTENT(IN)    :: NAME, VARNAME
REAL(KIND=JPRB), INTENT(IN)     :: NEWVALUE
REAL(KIND=JPRB), INTENT(OUT)    :: OLDVALUE
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_SETVAL',0,ZHOOK_HANDLE)
OLDVALUE = 0
IF (LEN(VARNAME) > 0) THEN
  IF (VARNAME(1:1) == '$') THEN
    IF (NAME == ' ') THEN
      OLDVALUE = ODB_SETVAL(HANDLE, VARNAME, NEWVALUE)
    ELSE
      OLDVALUE = ODB_SETVAL(HANDLE, VARNAME, NEWVALUE, VIEWNAME=NAME)
    ENDIF
  ELSE
    IF (NAME == ' ') THEN
      OLDVALUE = ODB_SETVAL(HANDLE, '$'//VARNAME, NEWVALUE)
    ELSE
      OLDVALUE = ODB_SETVAL(HANDLE, '$'//VARNAME, NEWVALUE, VIEWNAME=NAME)
    ENDIF
  ENDIF
ENDIF
IF (LHOOK) CALL DR_HOOK('F_ODB_SETVAL',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_SETVAL

SUBROUTINE F_ODB_IO_METHOD(HANDLE, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
USE ODB_MODULE, ONLY : ODB_IO_METHOD
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE
INTEGER(KIND=JPIM), INTENT(OUT) :: RC
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_IO_METHOD',0,ZHOOK_HANDLE)
RC = ODB_IO_METHOD(HANDLE)
IF (LHOOK) CALL DR_HOOK('F_ODB_IO_METHOD',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_IO_METHOD

SUBROUTINE F_ODB_GETSIZE(HANDLE, NAME, NROWS, NCOLS, NRA, POOLNO, RC)
USE PARKIND1  ,ONLY  : JPIM     ,JPRB
USE YOMHOOK   ,ONLY  : LHOOK,   DR_HOOK
USE ODB_MODULE, ONLY : ODB_GETSIZE
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(IN)  :: HANDLE, POOLNO
CHARACTER(LEN=*), INTENT(IN)    :: NAME
INTEGER(KIND=JPIM), INTENT(OUT) :: NROWS, NCOLS, NRA, RC
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('F_ODB_GETSIZE',0,ZHOOK_HANDLE)
RC = ODB_GETSIZE(HANDLE, NAME, NROWS, NCOLS, NRA=NRA, POOLNO=POOLNO)
IF (LHOOK) CALL DR_HOOK('F_ODB_GETSIZE',1,ZHOOK_HANDLE)
END SUBROUTINE F_ODB_GETSIZE
