/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef SUBPATCHMODULE_H
#define SUBPATCHMODULE_H

#include <string>
#include <libgnomecanvasmm.h>
#include "OmModule.h"
using std::string; using std::list;

namespace LibOmClient {
class PatchModel;
class NodeModel;
class PortModel;
class PatchWindow;
}
using namespace LibOmClient;

namespace OmGtk {
	
class OmPatchBayArea;
class NodeControlWindow;
class PatchController;


/** A module to represent a subpatch
 *
 * \ingroup OmGtk
 */
class SubpatchModule : public OmModule
{
public:
	SubpatchModule(OmPatchBayArea* patch_bay, PatchController* patch_controller);
	virtual ~SubpatchModule() {}

	void add_om_port(PortModel* pm, bool resize=true);
	void metadata_update(const MetadataModel* const mm);
	
	void on_double_click();

	void show_dialog();
	void show_patch_window();
	void menu_remove();

	PatchModel* patch_model() { return m_patch_model; }

protected:
	PatchModel*        m_patch_model;
	PatchController*   m_patch_controller;
};


} // namespace OmGtk

#endif // SUBPATCHMODULE_H
