/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OMAPP_H
#define OMAPP_H

#include <string>
#include "List.h"
#include "config.h"

using std::string;

namespace Om {

class JackDriver;
class AlsaDriver;
class NodeFactory;
class OSCReceiver;
class OSCSender;
class Patch;
class Maid;
class ObjectStore;


/** The main class for Om, the whole app lives in here
 *
 * \ingroup engine
 */
class OmApp
{
public:
	OmApp(const char* const port);
	~OmApp();
	
	int main();
	
	/** Set the quit flag that should kill all threads and exit cleanly.
	 * Note that it will take some time. */
	void quit() { m_quit_flag = true; }
	
	void activate();
	void deactivate();
	void enable();
	void disable();

	void add_patch(ListNode<Patch*>* const p) { m_patches.push_back(p); }
	void remove_patch(Patch* const patch);

	List<Patch*>& patches() { return m_patches; }
	
	const sample* const zero_buffer() { return m_zero_buffer; }

	Maid* const        maid()         { return m_maid; }
	JackDriver* const  jack_driver()  { return m_jack_driver; }
	AlsaDriver* const  alsa_driver()  { return m_alsa_driver; }
	OSCReceiver* const osc_receiver() { return m_osc_receiver; }
	OSCSender* const   osc_sender()   { return m_osc_sender; }
	ObjectStore* const object_store() { return m_object_store; }
	NodeFactory* const node_factory() { return m_node_factory; }
	
private:
	// Prevent copies
	OmApp(const OmApp& copy)            { exit(EXIT_FAILURE); }
	OmApp& operator=(const OmApp& copy) { exit(EXIT_FAILURE); }
	
	Maid*         m_maid;
	JackDriver*   m_jack_driver;
	AlsaDriver*   m_alsa_driver;
	OSCReceiver*  m_osc_receiver;
	OSCSender*    m_osc_sender;
	ObjectStore*  m_object_store;
	NodeFactory*  m_node_factory;
	List<Patch*>  m_patches;

	sample*        m_zero_buffer;
	
	bool m_quit_flag;
	bool m_activated;
};


} // namespace Om

#endif // OMAPP_H
