/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef POSTPROCESSOR_H
#define POSTPROCESSOR_H

#include <pthread.h>
#include <ctime>
#include "types.h"
#include "Event.h"
#include "Queue.h"

using std::string;

namespace Om {


/** Self driving thread, performs any post-execute() actions for events,
 * then pushes them on to the maid for deletion.
 *
 * \ingroup engine
 */
class PostProcessor
{
public:
	PostProcessor(size_t queue_size, const timespec& rate);
	~PostProcessor();

	void start();
	void stop();

	void push(Event* const ev);

private:
	// Prevent copies
	PostProcessor(const PostProcessor& copy) : m_events(0) { exit(EXIT_FAILURE); }
	PostProcessor& operator=(const PostProcessor& copy)    { exit(EXIT_FAILURE); }

	Queue<Event*> m_events;

	static void* process_events(void* me);
	void*        m_process_events();

	pthread_t       m_process_thread;
	bool            m_thread_exists;
	static bool     m_process_thread_exit_flag;
	timespec        m_rate;
};


} // namespace Om

#endif // POSTPROCESSOR_H
