# vcc3-pantilt.tcl --
#
#       Code for handling Pan/Tilt notifications and responses for vcc3d.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_presetMode
set g_presetMode "NO_SET"

proc vcc3_processPanTiltNotification {pktList} {
    array set pkt $pktList

    puts stdout "vcc3_processPanTiltNotification: called"
    vcc3_printPacket $pktList

    set type [expr $pkt(commandID) & 0x1F]
    if {$type == 0x18} {
	puts stdout "vcc3_processPanTiltNotification: remote control"
	set operation $pkt(parameter,0)
	set code $pkt(parameter,1)
	vcc3_pt_handleRemoteButton $operation $code
    }
}

# the vcc3 notifies the pc when a remote button is pushed, but it doesn't
#    do anything
#
# this part of the code allows the remote to work normally when pc control
#    is enabled
proc vcc3_pt_handleRemoteButton {op code} {
    global g_presetMode

    # op == 1 => button down
    # op == 0 => button up
    
    if {$code == 0x0} {
	# manual button
	if {$op} { vcc3_setFocusMode "manual" }
    }
    if {$code == 0x1} {
	# home button
	if {$op} { vcc3_home }
    }
    if {$code == 0x10} {
	# 1 button
	if {$op} {
	    if {$g_presetMode == "PRESET_ACTIVE"} {
		vcc3_setPreset 1
		set g_presetMode "NO_SET"
	    } else {
		vcc3_goPreset 1
	    }
	}   
    }
    if {$code == 0x20} {
	# 2 button
	if {$op} {
	    if {$g_presetMode == "PRESET_ACTIVE"} {
		vcc3_setPreset 2
		set g_presetMode "NO_SET"
	    } else {
		vcc3_goPreset 2
	    }
	}   
    }
    if {$code == 0x30} {
	# 3 button
	if {$op} {
	    if {$g_presetMode == "PRESET_ACTIVE"} {
		vcc3_setPreset 3
		set g_presetMode "NO_SET"
	    } else {
		vcc3_goPreset 3
	    }
	}   
    }
    if {$code == 0x40} {
	# 4 button
	if {$op} {
	    if {$g_presetMode == "PRESET_ACTIVE"} {
		vcc3_setPreset 4
		set g_presetMode "NO_SET"
	    } else {
		vcc3_goPreset 4
	    }
	}   
    }
    if {$code == 0x50} {
	# 5 button
	if {$op} {
	    if {$g_presetMode == "PRESET_ACTIVE"} {
		vcc3_setPreset 5
		set g_presetMode "NO_SET"
	    } else {
		vcc3_goPreset 5
	    }
	}   
    }
    if {$code == 0x60} {
	# 6 button
	if {$op} {
	    if {$g_presetMode == "PRESET_ACTIVE"} {
		vcc3_setPreset 6
		set g_presetMode "NO_SET"
	    } else {
		vcc3_goPreset 6
	    }
	}   
    }
    if {$code == 0x70} {
	# auto button
	if {$op} { vcc3_setFocusMode "auto" }
    }
    if {$code == 0x80} {
	# near button
	if {$op} {vcc3_startFocus "near"} else { vcc3_stopFocus }
    }
    if {$code == 0x90} {
	# far button
	if {$op} {vcc3_startFocus "far"} else { vcc3_stopFocus }
    }
    if {$code == 0xA0} {
	# wide button
	if {$op} { vcc3_startOut } else { vcc3_stop }
    }
    if {$code == 0xB0} {
	# tele button
	if {$op} { vcc3_startIn } else { vcc3_stop }
    }
    if {$code == 0xC0} {
	# up button
	if {$op} { vcc3_startUp } else { vcc3_stop }
    }
    if {$code == 0xD0} {
	# down button
	if {$op} { vcc3_startDown } else { vcc3_stop }
    }
    if {$code == 0xE0} {
	# left button
	if {$op} { vcc3_startLeft } else { vcc3_stop }
    }
    if {$code == 0xF0} {
	# right button
	if {$op} { vcc3_startRight } else { vcc3_stop }
    }
    if {$code == 0x51} {
	# preset button
	if {$op} {
	    if {$g_presetMode == "PRESET_ACTIVE"} {
		set g_presetMode "NO_SET"
		puts stdout "setting to no_set: g_presetMode is $g_presetMode"
	    } else {
		set g_presetMode "PRESET_ACTIVE"
		puts stdout "setting to preset_active: g_presetMode is $g_presetMode"
	    }
	}
    }
    if {$code == 0x41} {
	# operate button
    }
}

proc vcc3_processPanTiltPositiveResponse {pktList} {
    global g_sync
    
    array set pkt $pktList

    set type [expr $pkt(commandID) & 0x1F]
    if {$type == 0x4} {
	# status response
	vcc3_pt_handleStatusResponse $pktList
    }
    if {$type == 0x10} {
	# setup response
	vcc3_pt_handleSetupResponse $pktList
    }
    if {$type == 0x11} {
	# home position response
	set g_sync(home) "NO_WAIT"
    }
    if {$type == 0x12} {
	# pan/tilt response
	vcc3_pt_handlePanTiltResponse $pktList
    }

}

proc vcc3_processPanTiltNegativeResponse {pktList} {
    global g_sync
    
    array set pkt $pktList

    set type [expr $pkt(commandID) & 0x1F]
   #   if {$type == 0x4} {
#  	# status response
#  	vcc3_pt_handleStatusResponse $pktList
#      }
#      if {$type == 0x10} {
#  	# setup response
#  	vcc3_pt_handleSetupResponse $pktList
#      }
#      if {$type == 0x11} {
#  	# home position response
#  	set g_sync(home) "NO_WAIT"
#      }
    if {$type == 0x12} {
	# pan/tilt response (probably at a limit)
	vcc3_pt_handlePanTiltResponse $pktList
    }

}

proc vcc3_pt_handleSetupResponse {pktList} {
    global g_sync g_panSpeed g_tiltSpeed g_panPosition g_tiltPosition
    array set pkt $pktList

    set panHi $pkt(parameter,0)
    set panLo $pkt(parameter,1)
    set tiltHi $pkt(parameter,2)
    set tiltLo $pkt(parameter,3)
    set panHi [expr $panHi << 8]
    set tiltHi [expr $tiltHi << 8]
    set g_panPosition [expr $panHi + $panLo]
    set g_tiltPosition [expr $tiltHi + $tiltLo]
    set g_panPosition [expr 0x8000 - $g_panPosition]
    set g_tiltPosition [expr $g_tiltPosition - 0x8000]
    set g_sync(panTiltSetup) "NO_WAIT"
}

proc vcc3_pt_handleStatusResponse {pktList} {
    global g_sync g_panSpeed g_tiltSpeed g_panPosition g_tiltPosition
    array set pkt $pktList

    set type $pkt(parameter,0)
    if {$type == 0x2} {
	# pan/tilt
	set g_panSpeed $pkt(parameter,1)
	set g_tiltSpeed $pkt(parameter,4)
	set panHi $pkt(parameter,2)
	set panLo $pkt(parameter,3)
	set tiltHi $pkt(parameter,5)
	set tiltLo $pkt(parameter,6)
	set panHi [expr $panHi << 8]
	set tiltHi [expr $tiltHi << 8]
	set g_panPosition [expr $panHi + $panLo]
	set g_tiltPosition [expr $tiltHi + $tiltLo]
	set g_panPosition [expr 0x8000 - $g_panPosition]
	set g_tiltPosition [expr $g_tiltPosition - 0x8000]
	set g_sync(readPanTiltStatus) "NO_WAIT"
    }
}

proc vcc3_pt_handlePanTiltResponse {pktList} {
    global g_sync g_panSpeed g_tiltSpeed g_panPosition g_tiltPosition
    array set pkt $pktList

    set type $pkt(parameter,0)
    if {$type == 0x1} {
	# pan/tilt start
	set g_sync(startMove) "NO_WAIT"
    }
    if {$type == 0x2} {
	# pan/tilt stop
	set g_sync(stopMove) "NO_WAIT"
    }
    if {$type == 0x3} {
	# pan/tilt speed
	if {$pkt(parameter,1) == 0x1} {
	    # read
	    set g_panSpeed $pkt(parameter,2)
	    set g_tiltSpeed $pkt(parameter,3)
	    set g_sync(readPanTiltSpeed) "NO_WAIT"
	}
    }
    if {$type == 0x4} {
	# relative pan/tilt position
	if {$pkt(parameter,1) == 0x2} {
	    set g_sync(relativeMove) "NO_WAIT"
	}
	if {$pkt(parameter,1) == 0x1} {
	    # read
	    set panHi $pkt(parameter,2)
	    set panLo $pkt(parameter,3)
	    set tiltHi $pkt(parameter,4)
	    set tiltLo $pkt(parameter,5)

	    set panHi [expr $panHi << 8]
	    set tiltHi [expr $tiltHi << 8]
	    set g_panPosition [expr $panHi + $panLo]
	    set g_tiltPosition [expr $tiltHi + $tiltLo]
	    set g_panPosition [expr 0x8000 - $g_panPosition]
	    set g_tiltPosition [expr $g_tiltPosition - 0x8000]    
#	    puts stdout "relative: panHi=$panHi, panLo=$panLo"
#	    puts stdout "relative: tiltHi=$tiltHi, tiltLo=$tiltLo"
#	    puts stdout "relative: g_panPos=$g_panPosition, g_tiltPosition=$g_tiltPosition"
	    set g_sync(readPanTiltPosition) "NO_WAIT"
	}
    }
    if {$type == 0x5} {
	# absolute pan/tilt position
	if {$pkt(parameter,1) == 0x2} {
	    set g_sync(absoluteMove) "NO_WAIT"
	}
	if {$pkt(parameter,1) == 0x1} {
	    # read
	    set panHi $pkt(parameter,2)
	    set panLo $pkt(parameter,3)
	    set tiltHi $pkt(parameter,4)
	    set tiltLo $pkt(parameter,5)
	    set panHi [expr $panHi << 8]
	    set tiltHi [expr $tiltHi << 8]
	    set g_panPosition [expr $panHi + $panLo]
	    set g_tiltPosition [expr $tiltHi + $tiltLo]
	    set g_panPosition [expr 0x8000 - $g_panPosition]
	    set g_tiltPosition [expr $g_tiltPosition - 0x8000]
	    set g_sync(readPanTiltPosition) "NO_WAIT"
	}
    }
}
