/*
 * framer-jpeg.cc --
 *
 *      Jpeg Framer
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/codec/framer-jpeg.cc,v 1.10 2002/02/03 03:13:33 lim Exp $";
#endif

#include "config.h"
#include "rtp.h"
#include "pktbuf-rtp.h"
#include "module.h"

class JpegFramer : public EncoderModule {
 public:
	~JpegFramer();
	virtual void recv(Buffer*);
};

static class JpegFramerClass : public TclClass {
public:
	JpegFramerClass() : TclClass("Module/Framer/JPEG") {}
	TclObject* create(int /* argc */, const char*const* /* argv */) {
		return (new JpegFramer);
	}
} framer_matcher_jpeg;

JpegFramer::~JpegFramer()
{
}

#define HLEN (sizeof(jpeghdr) + sizeof(rtphdr))

void JpegFramer::recv(Buffer* bp)
{
	JpegFrame* p = (JpegFrame*)bp;

	int tot = p->len_;
	int off = 0;
	int payload = mtu_ - HLEN;
	while (off < p->len_) {
		pktbuf* pb = pool_->alloc(p->ts_, RTP_PT_JPEG);
		rtphdr* rh = (rtphdr*)pb->dp;
		jpeghdr* h = (jpeghdr*)(rh + 1);

		/*FIXME could maintain this as one 32-bit value */
		h->q = p->q_;
		h->width = p->width_ >> 3;
		h->height = p->height_ >> 3;
		h->type = p->type_;

		int cc = p->len_ - off;
		if (cc > payload)
			cc = payload;
		else
			rh->rh_flags |= htons(RTP_M);

		h->off = htonl(off);
		pb->len = cc + HLEN;
		/*FIXME it'd be nice to avoid this copy */
		memcpy(h + 1, (u_int8_t*)p->bp_ + off, cc);
		target_->recv(pb);
		tot += HLEN;
		off += cc;
	}
	nb_ += tot;
}
