/*
 * xil2jfif.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <sys/file.h>

/*
 * Write the first frame of a vic dump file to
 * stdout, as a JFIF format file.
 */
main(int argc, char **argv)
{
	int fd, cc, len;
	int start = 0;
	int end = 0;
	u_char *p;
	int op, n;
	extern int optind, opterr;
	extern char *optarg;
	char *ofile = "out";
	u_char *bp;
	u_char buffer[80 * 1024];

	opterr = 0;
	while ((op = getopt(argc, argv, "n:s:e:o:")) != -1) {
		switch (op) {

		case 'n':
			start = end = atoi(optarg);
			break;

		case 's':
			start = atoi(optarg);
			break;

		case 'e':
			end = atoi(optarg);
			break;

		case 'o':
			ofile = optarg;
			if (strlen(ofile) > 200)
				exit(1);
			break;
		}
	}
	argc -= optind;
	argv += optind;

	if (argc != 1)
		exit(1);

	fd = open(*argv, O_RDONLY);
	if (fd < 0) {
		perror(*argv);
		exit(1);
	}
	cc = read(fd, (char*)buffer, sizeof(buffer));
	close(fd);
	bp = &buffer[16];
	cc -= 16;

	len = ntohl(*(int*)bp);
	bp += 4;
	cc -= 4;

	write(1, bp, len);

	exit(0);
}
