/*
 * win32x.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * This module contributed by John Brezak <brezak@apollo.hp.com>.
 * January 31, 1996
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/compat/win32x.c,v 1.8 2002/02/03 03:14:22 lim Exp $";
#endif

#include "tkWinInt.h"
#include "assert.h"

XImage *
XGetSubImage(
    Display*		display,
    Drawable		d,
    int			x,
    int			y,
    unsigned int	width,
    unsigned int	height,
    unsigned long	plane_mask,
    int			format,
    XImage*		dest_image,
    int			dest_x,
    int			dest_y
)
{
    printf("XGetSubImage: not implemented!\n");
    return(NULL);
}

unsigned long *win32Colors;
int win32NColors = 0;

/*
 * These functions belong in the TkWin port code
 */

/*
 *----------------------------------------------------------------------
 *
 * XClearArea --
 *
 *	Clears the specified area in the window to the current
 * 	background color.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Erases the specified area of the window.
 *
 *----------------------------------------------------------------------
 */
void
XClearArea(display, w, x ,y, width, height, exposures)
    Display* display;
    Window w;
    int x;
    int y;
    unsigned int width;
    unsigned int height;
    Bool exposures;
{
    RECT rc;
    HBRUSH brush;
    HPALETTE oldPalette, palette;
    TkWindow *winPtr;
    HWND hwnd = TkWinGetHWND(w);
    HDC dc = GetDC(hwnd);

    palette = TkWinGetPalette(display->screens[0].cmap);
    oldPalette = SelectPalette(dc, palette, FALSE);

    display->request++;

    winPtr = TkWinGetWinPtr(w);
    brush = CreateSolidBrush(winPtr->atts.background_pixel);
    GetWindowRect(hwnd, &rc);
    rc.right = rc.right - rc.left;
    rc.bottom = rc.bottom - rc.top;
    rc.left = rc.top = 0;

    if (width!=0) {
	rc.left=(LONG)x;
	rc.right=(LONG)(x + width + 1);
    }

    if (height !=0) {
	rc.top=(LONG)y;
	rc.bottom=(LONG)(y + height + 1);
    }

    FillRect(dc, &rc, brush);

    DeleteObject(brush);
    SelectPalette(dc, oldPalette, TRUE);
    ReleaseDC(hwnd, dc);
}
