/*
 * rep-encoder-jpegcompressed2jpeg.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "inet.h"
#include "net.h"
#include "rtp.h"
#include "codec/dct.h"
#include "bsd-endian.h"
#include "Tcl.h"
#include "pktbuf-rtp.h"
#include "codec/module.h"
#include "vidreps.h"

#define HDRSIZE (sizeof(rtphdr) + 8)

class JpegCompressedToJpegEncoder : public EncoderModule {
public:
  JpegCompressedToJpegEncoder();
  void recv(JPEGCompressed* fb);
  void recv(Buffer *bp);
  void size(int w, int h);

protected:
  int command(int argc, const char*const* argv);

  int flush(pktbuf* pb, int nbit, pktbuf* npb);

  u_int offset_;
  u_char w_;			/* divided by 8 */
  u_char h_;
};

static class JpegCompressedToJpegEncoderClass : public TclClass {
public:
  JpegCompressedToJpegEncoderClass() : TclClass("Module/VideoEncoder/JPEGCompressedToJPEG") {}
  TclObject* create(int, const char*const*) {
    return (new JpegCompressedToJpegEncoder);
  }
} jpeg_compressed_to_jpeg_encoder_class_;

JpegCompressedToJpegEncoder::JpegCompressedToJpegEncoder() : EncoderModule(),
  offset_(0), w_(0), h_(0)
{
}

void
JpegCompressedToJpegEncoder::size(int w, int h)
{
  FrameModule::size(w, h);
  if (w&0xf || h&0xf) {
    fprintf(stderr, "JpegCompressedToJpegEncoder: bad geometry: %dx%d\n", w, h);
    exit(1);
  }
  w_ = w>>3;
  h_ = h>>3;
}

int
JpegCompressedToJpegEncoder::command(int argc, const char*const* argv)
{
  if (argc == 3 && strcmp(argv[1], "recv") == 0) {
    JPEGCompressed *input = (JPEGCompressed *) TclObject::lookup(argv[2]);
    if (input != 0) {
      recv(input);
    }
    return (TCL_OK);
  }
  return (EncoderModule::command(argc, argv));
}

void
JpegCompressedToJpegEncoder::recv(JPEGCompressed* fb)
{
  pktbuf *pb;
  rtphdr *rh;
  jpeghdr *h;
  u_char *bp;

  if (!(fb->w_ == width_ &&
	fb->h_ == height_)) {
    size(fb->w_, fb->h_);
  }

  offset_ = 0;
  int fragsize = mtu_ - HDRSIZE;

  pb = 0;

  while (offset_ < fb->len_) {
    if (pb != 0) {
      target_->recv(pb);
    }

    pb = pool_->alloc(htonl(fb->ts_), RTP_PT_JPEG);
    rh = (rtphdr*)(pb->data);
    h = (jpeghdr *)(rh+1);
    bp = &pb->data[HDRSIZE];

    h->off = htonl(offset_);
    h->type = 0;
    h->q = fb->q_;
    h->width = w_;
    h->height = h_;

    if (fragsize > fb->len_-offset_) {
      fragsize = fb->len_-offset_;
    }
    memcpy(bp, &fb->bp_[offset_], fragsize);
    offset_ += fragsize;
    pb->len = fragsize + HDRSIZE;
  }
  if (pb != 0) {
    rh->rh_flags |= htons(RTP_M);
    target_->recv(pb);
  }
}

void
JpegCompressedToJpegEncoder::recv(Buffer* bp)
{
  recv((JPEGCompressed *) bp);
  return;
}

