/*
 * server_def.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_RTSP_SERVER_DEFINITIONS_H
#define MASH_RTSP_SERVER_DEFINITIONS_H


typedef struct SessionSettings
{
   u_long   session_id;
	//SOCKIN   saddr_in;            /* ip address & port # for data channel */
   u_short  data_port;
   time_t   start;               /* play range */
   time_t   finish;
   long     max_bit_rate;
   long     ave_bit_rate;
   long     max_pkt_size;
   long     ave_pkt_size;
   int      num_interleave_pkts;
   long     duration;
   int      preroll;
   int      media_flags;
   int      num_streams;
} SSET;

#define MAXSTREAMSESSIONS 20

typedef struct Stream
{
   struct Stream  *next;
   u_short        stream_id;
   u_short        mime_type;
   long           max_bit_rate;
   long           ave_bit_rate;
   long           max_pkt_size;
   long           ave_pkt_size;
   u_short        preroll;
   long           duration;
   u_long         xmit_interval;
   u_long        start_time;
   u_short        stream_flags;
   int            stream_fd;
   u_long         start_offset;
   u_long         byte_count;
   u_long         bytes_per_sec;
	//PCM_HDR        PCM_hdr;
   char           type_data[256];
   char           filename[512];
   void           *streamer;
   u_short        seq_num;

} STREAM;

#define CONTENTLENGTH "Content-Length"

struct Session_State
{
	u_long   session_id;
	int      cur_state;
	int      flags;      /* used with settings and instance. */
	SSET     settings;
	STREAM   *streams;
	char     serverurl[256];
	char     url[256];

   int sessionlist_stream_ids[MAXSTREAMSESSIONS];
   u_short sessionlist[MAXSTREAMSESSIONS];

};

/* method codes */
#define RTSP_SETUP_METHOD     0
#define RTSP_GET_METHOD       1
#define RTSP_REDIRECT_METHOD  2
#define RTSP_PLAY_METHOD      3
#define RTSP_PAUSE_METHOD     4
#define RTSP_SESSION_METHOD   5
#define RTSP_HELLO_METHOD     6
#define RTSP_RECORD_METHOD    7
#define RTSP_CLOSE_METHOD     8
#define RTSP_GET_PARAM_METHOD 9
#define RTSP_SET_PARAM_METHOD 10
#define RTSP_EXTENSION_METHOD 11

/*
 * method response codes.  These are 100 greater than their
 * associated method values.  This allows for simplified
 * creation of event codes that get used in event_handler()
 */
#define RTSP_SETUP_RESPONSE      100
#define RTSP_GET_RESPONSE        101
#define RTSP_REDIRECT_RESPONSE   102
#define RTSP_PLAY_RESPONSE       103
#define RTSP_PAUSE_RESPONSE      104
#define RTSP_SESSION_RESPONSE    105
#define RTSP_HELLO_RESPONSE      106
#define RTSP_RECORD_RESPONSE     107
#define RTSP_CLOSE_RESPONSE      108
#define RTSP_GET_PARAM_RESPONSE  109
#define RTSP_SET_PARAM_RESPONSE  110
#define RTSP_EXTENSION_RESPONSE  111





#endif
