# ui-rover.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/collaborator/ui-rover.tcl,v 1.5 2002/02/03 04:21:46 lim Exp $


WidgetClass RoverPanel -default {
	{ *borderWidth 1 }
}


RoverPanel public destroy { } {
	$self instvar timer_id_
	if [info exists timer_id_] {
		after cancel $timer_id_
	}
}


RoverPanel public build_widget { w } {
	set f [$self get_option helv10o]
	menubutton $w.bookmarks -image CollaboratorIcons(bookmark) \
			-relief raised -bd 2 -menu $w.bookmarks.menu \
			-state disabled
	set bm_menu [menu $w.bookmarks.menu]
	$bm_menu add command -label "Add bookmark" -state disabled
	$bm_menu add command -label "Edit bookmarks" -state disabled
	$bm_menu add separator
	$self set_subwidget bm_menu $bm_menu

	button $w.play_pause -image VcrIcons(play) -highlightthickness 0 \
			-state disabled -command "\[$self set client_\] \
			play_or_pause \[set \[$self tkvarname offset_\]\]"
	scale $w.slider -state disabled -orient horizontal \
			-from 0 -to 100 -font $f -showvalue true \
			-variable [$self tkvarname offset_] \
			-command "$self slider_moved_interactively"
	pack $w.bookmarks $w.play_pause -side left -anchor n -padx 1 -pady 1
	pack $w.slider -side left -fill both -expand 1
}


RoverPanel public ssac_client { c } {
	$self set client_ $c
}


RoverPanel public slider_moved_interactively { offset } {
	$self instvar client_
	if { [$self subwidget play_pause cget -image] == "VcrIcons(pause)" } {
		# the button displays PAUSE, i.e. we are currently in PLAY mode
		$client_ send PLAY [expr int($offset)] 1
	}
}


RoverPanel public move_slider { offset } {
	$self instvar timer_id_
	if { [$self subwidget play_pause cget -image] == "VcrIcons(pause)" } {
		# the button displays PAUSE, i.e. we are currently in PLAY mode
		$self tkvar offset_
		set offset_ $offset
	}
	if [info exists timer_id_] { after cancel $timer_id_ }
	set timer_id_ [after 2000 "$self update_slider"]
}


RoverPanel public update_slider { } {
	$self instvar timer_id_
	if { [$self subwidget play_pause cget -image] == "VcrIcons(pause)" } {
		# the button displays PAUSE, i.e. we are currently in PLAY mode
		$self tkvar offset_
		set offset_ [expr $offset_ + 2]
	}
	set timer_id_ [after 2000 "$self update_slider"]
}


RoverPanel public activate_slider { start end } {
	set path [$self info path]
	set mf [$self get_option medfont]
	$path.slider configure -state normal -font $mf \
			-from 0 -to [expr int($end -$start)] \
			-tickinterval [expr int(0.49 * ($end - $start))]
	$path.play_pause configure -state normal
	$path.bookmarks configure -state normal

	$self instvar timer_id_
	set timer_id_ [after 2000 "$self update_slider"]
}


RoverPanel public play_update { state } {
	$self subwidget play_pause configure -image \
			VcrIcons([string tolower $state])
}

