# main.tcl --
#
#       This is the main entry point for the pathfinder tool.
#       Tcl source code expansion with tcl-expand.tcl starts here.
#       Tcl execution also starts here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/pathfinder/main.tcl,v 1.6 2002/02/10 03:55:45 lim Exp $


import HTTP_Server/MASH_Server HTTP_Agent/SDP_Agent HTTP_Agent/Rec_Agent \
		HTTP_Agent/Play_Agent HTTP_Agent/Static
import DynamicHTMLifier
import MTrace

MTrace init { trcNet }

set sdp_agent [new HTTP_Agent/SDP_Agent]
set rec_agent [new HTTP_Agent/Rec_Agent]
set play_agent [new HTTP_Agent/Play_Agent]
set static_agent [new HTTP_Agent/Static]

set server [new HTTP_Server/MASH_Server]
$server add_agent $sdp_agent
$server add_agent $rec_agent
$server add_agent $play_agent
$server add_agent $static_agent
$server open [$server get_option server_port]

vwait forever
