# dc-service.tcl --
#
#       Contains CServiceManager and CService, building blocks of DC
#       Service Discovery Service.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import CLinkManager
import CLink

Class CServiceManager -superclass CLinkManager

CServiceManager public init { szType szAttribute iPort }  {
    $self next $iPort

    $self instvar m_szType
    $self instvar m_szAttribute

    set m_szType $szType
    set m_szAttribute $szAttribute
}


CServiceManager private NewConnection { newSocket inetAddr iPort } {
    $self instvar m_lAttach
    $self instvar m_lService
    $self instvar m_szType
    $self instvar m_szAttribute

    # send out this service manager's type and attribute
    puts $newSocket "$m_szType"
    puts $newSocket "$m_szAttribute"
    flush $newSocket

    # get the remote service's type and attribute
    set szType [gets $newSocket]
    set szAttribute [gets $newSocket]

    # create the new service with the socket
    set service [new CService $newSocket $inetAddr $iPort $szType $szAttribute]

    # now go through the list of attached objects and see if anyone wants it
    foreach attach $m_lAttach {
	set result [$attach NewConnection $service]
	if { $result != 0 } {
	    return
	}
    }

    # ok no one want's it so stick into a list and maybe some will want it
    # later
    lappend m_lService $service
}

CServiceManager instproc NewService { inetRemoteAddr iRemotePort \
	{ szType "" } { szAttribute "" } } {
    $self instvar m_szType
    $self instvar m_szAttribute

    # first create the new socket
    if {[catch {socket $inetRemoteAddr $iRemotePort} sock]} {
	puts "CServiceManager: NewService couldn't connect to ${inetRemoteAddr}/${iRemotePort}"
	return 0
    }

    # check that the socket is good
    if { $sock <= 0 } {
	puts "CServiceManager: NewService couldn't connect socket to host"
	return 0
    }

    # get the remote service's type and attribute
    set szRemoteType [gets $sock]
    set szRemoteAttribute [gets $sock]

    # send out this service manager's type and attribute
    if { $szType == "" && $szAttribute == "" } {
	set szType $m_szType
	set szAttribute $m_szAttribute
    }

    puts $sock "$szType"
    puts $sock "$szAttribute"
    flush $sock

    set service [new CService $sock $inetRemoteAddr $iRemotePort \
	    $szRemoteType $szRemoteAttribute]

    return $service
}





Class CService -superclass CLink
# CService friend CServiceManager

CService private init { sock inetAddr iPort szType szAttribute } {
    $self next $sock 

    $self instvar m_szType
    $self instvar m_szAttribute

    set m_szType $szType
    set m_szAttribute $szAttribute
}

