# simple-video-rx.tcl --
#
#       A simple video receiver
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

if {[catch {source [file join $env(TCLCL_IMPORT_DIRS) import.tcl]} res]} {
	puts "error sourcing the import.tcl initialization script: $res"
}

Import enable
import Application AddressBlock VideoAgent TkWindow
import VideoWidget


#
# SimpleVideoRxApp
#
Class SimpleVideoRxApp -superclass Application

SimpleVideoRxApp instproc init {} {
	$self next sv
	$self instvar agent_ srcmgr_

	#$self add_default defaultTTL 16

	# a VideoAgent object abstracts away the networking
	set spec 224.1.2.3/12345
	set agent_ [new VideoAgent $self $spec]
	puts "Listening to $spec"

	# another object (called SimpleVideoRxSourceManager) is in charge 
	# of listening to the VideoAgent events and responding to them
	set srcmgr_ [new SimpleVideoRxSourceManager $agent_]

	# let's request the videoagent to send events to the source manager
	$agent_ attach $srcmgr_
}


#
# SimpleVideoRxSourceManager
#
Class SimpleVideoRxSourceManager -superclass Observer

SimpleVideoRxSourceManager instproc init {agent} {
	$self next
	$self instvar agent_ target_

	# just write up the name of the VideoAgent
	set agent_ $agent

	# initialize the target_ handler. The target_ is the object that will 
	#	receive the frames once they've been decoded
	set target_ ""
}

#
#	SimpleVideoRxSourceManager::trigger_sdes
#
#	trigger_sdes is an event raised by the VideoAgent when somebody 
#	joins our session
#
SimpleVideoRxSourceManager instproc trigger_sdes {src} {
	puts "trigger_sdes: [$src sdes cname] ([$src sdes name]) joined the session"
}

#
#	SimpleVideoRxSourceManager::trigger_media
#
#	trigger_media is an event raised by the VideoAgent when some source 
#	joined to our session starts transmitting
#
SimpleVideoRxSourceManager instproc trigger_media {src} {

	# we wait a little to give time for the VideoAgent to create and install 
	# a decoder, and for such decoder to get one packet so that it can 
	# realize the format, size, and color subsampling scheme of the video 
	# stream
	after idle "$self really_activate $src"
}

#
#	SimpleVideoRxSourceManager::really_activate
#
#	when a source has started transmitting and the decoder is already 
#	installed, really_activate attaches a renderer object to the decoder's 
#	output
#
SimpleVideoRxSourceManager instproc really_activate {src} {

	$self instvar window_ target_ decoder_ decimation_ window_ renderer_

	puts "trigger_media: [$src sdes cname] ([$src sdes name]) is transmitting"

	# get the decoder handler
	set decoder_ [$src handler]
	if {$decoder_ == ""} {
		puts "\tcouldn't find a decoder"
		return
	} else {
		puts "\tVideoAgent created a decoder [$decoder_ info class]"
	}

	# create a receiver for the frames (the Renderer object)
	set renderer_ [new Renderer/Null]

	# attach the renderer to the decoder's output
	$decoder_ attach $renderer_
}

# get rid of the main window
wm withdraw .

# create the main object
set app [new SimpleVideoRxApp]


# ///////////////////////////////
# to get the display propierties
#import VisualFrame
#set vframe_ [new VisualFrame .top]
#[$vframe_ set colorModel_] info class; # returns Colormodel/TrueColor/24

