# fca-fcp.tcl --
#
#       floor control policy -- should be obtained from SDR plug in
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# Data members for Class FCAFloorConfig:
# floor_: on which the floor is used against
#            vat, vic, mb (bit 2, bit 1, bit0)
#            111 (7) - all resources;
#            110 (6)- vat and vic
#            ...
# maxHldrs_: max number of floor holders for this floor
#
Class FCAFloorConfig
FCAFloorConfig instproc init {floorType maxHldrs} {
    $self next
    $self instvar floorType_ maxHldrs_
    set maxHldrs_ $maxHldrs
    set floorType_ $floorType
}

FCAFloorConfig instproc floorType {} {
    $self instvar floorType_
    return $floorType_
}

FCAFloorConfig instproc maxHldrs {} {
    $self instvar maxHldrs_
    return $maxHldrs_
}

FCAFloorConfig instproc setMaxHldrs {max} {
    $self instvar maxHldrs_
    set maxHldrs_ $max
}

FCAFloorConfig instproc print {} {
    $self instvar floorType_ maxHldrs_
    puts "floorType: $floorType_  (bit 2: vat; bit 1: vic; bit 0: mb)"
    puts "max holders: $maxHldrs_"
}

# Data members of Class FCAPolicy (floorType control policy)
# flCfg_ : list of floorType config's
# numChairs_: number of chairs in the conference
# manual_:  manually moderated
# maxRqs_:  max requests that show on each one's window
# maxFls_:  max number of floorTypes that can be specified


Class FCAPolicy

# for now:
FCAPolicy instproc init { manual numModerators maxRqs } {
    $self next
    $self instvar maxFls_ flCfgs_ numModerators_ manual_ maxRqs_
    #if {$manual=={}} {
	#set manual_ 1
	#set numModerators_ 1
	#set maxRqs_ 20
	#set maxFls_ 2
	## 1 (vat and vic as one floorType), 2 (mb as another floorType)
	#set f1 [new FCAFloorConfig 1 1]
	#set f2 [new FCAFloorConfig 2 2]
	#lappend flCfgs_ $f1 $f2
	#return
    #}
    set manual_ $manual
    set numModerators_ $numModerators
    set maxRqs_ $maxRqs
    set maxFls_ 0
    set flCfgs_ {}
}

FCAPolicy instproc addFloor { floorType maxHolders } {
    $self instvar maxFls_ flCfgs_
    incr maxFls_
    lappend flCfgs_ [new FCAFloorConfig $floorType $maxHolders]
}


FCAPolicy instproc numFloorTypes {} {
    $self instvar flCfgs_
    return [llength $flCfgs_]
}

FCAPolicy instproc floorConfigs {} {
    $self instvar flCfgs_
    return $flCfgs_
}

FCAPolicy instproc maxRqs {} {
    $self instvar maxRqs_
    return $maxRqs_
}

FCAPolicy instproc numModerators {} {
    $self instvar numModerators_
    return $numModerators_
}

# return all the floor types (resource bitmaps)
FCAPolicy instproc floorTypes {} {
    $self instvar flCfgs_
    set returnftypes {}
    foreach i $flCfgs_ {
	lappend returnftypes [$i floorType]
    }
    return $returnftypes
}

FCAPolicy instproc newFloorType {floorType maxHldrs} {
    $self instvar maxFls_, flCfgs_
    if {[$self numFloorTypes] >= $maxFls_} {
	puts "There are already max $maxFls_ floors specified."
	return
    }
    foreach i $flCfgs_ {
        set f [$i floorType]
	if {$f == $floorType } {
	    puts "There is already a floor for $floorType."
	    return
	}
    }
    lappend flCfgs_ [new FCAFloorConfig $floorType $maxHldrs]
}

FCAPolicy instproc setMaxRqs { maxRqs } {
    $self instvar maxRqs_
    set maxRqs_ $maxRqs
}

FCAPolicy instproc setMaxFls { maxFls } {
    $self instvar maxFls_
    set maxFls_ $maxFls
}

FCAPolicy instproc getMaxHdlrs { floorType } {
    $self instvar flCfgs_
    foreach i $flCfgs_ {
	set f [$i floorType]
	if {$floorType == $f} {
	    return [$i maxHldrs]
	}
    }
}

FCAPolicy instproc setMaxHldrs {floorType max} {
    $self instvar flCfgs_
    foreach i $flCfgs {
	set f [$i floorType]
	if {$f == $floorType} {
	    $i setMaxHldrs max
	    return
	}
    }
    puts "floorType($floorType) not found"
}

FCAPolicy instproc print {} {
    $self instvar flCfgs_ maxFls_ manual_ numModerators_
    puts "manual = $manual_; num of moderators = $numModerators_"
    puts "Floors created = [$self numFloorTypes]; max floors allowed = $maxFls_"
    if {[$self numFloorTypes]==0} {
	puts "No floors have been created."
	return
    }

    foreach i $flCfgs_ {
        puts "$i"
	set f [$i floorType]
        set m [$i maxHldrs]
	puts "floor($f); max holders($m)"
    }
}
