# main.tcl --
#
#       This is the main entry point for the handoffServer tool.
#       Tcl source code expansion with tcl-expand.tcl starts here.
#       Tcl execution also starts here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# handoffServer
#
# must be run as root for routing updates to work
#-----
#


import AnnounceListenManager

#
# Accepts msgs to update routing tables for manual mobility management
#
Class AnnounceListenManager/RoutingTableAgent -superclass AnnounceListenManager

#
AnnounceListenManager/RoutingTableAgent instproc recv_announcement  {args} {
	puts "$args"
	set addr [lindex $args 0]
	set cmd [lindex $args 2]
	# ignore args port 1, length 3
	if {[llength $cmd] == 4} {
		if {[lindex $cmd 0] == "SetRoute"} {
			# Assuming '$addr == [lindex $cmd 1]' for now --
			# should do DNS check?
			#puts "SetRoute $addr [lindex $cmd 2]"
			eval $self SetRoute $addr [lindex $cmd 2]
		}
	}
}

#
AnnounceListenManager/RoutingTableAgent private SetRoute {client newBS} {

	puts "\[[exec date]\]: SetRoute $client $newBS"
	set client [$self NSLookup $client]
	if {[catch "exec netstat -rn | grep $client" netstatReply]} {
		puts "no route to client $client"
		if {[catch "eval exec route add $client $newBS" result]} {
			puts "Error on route add:\n$result"
		}
	} else {
		exec route delete -host $client
		if {[catch "eval exec route add $client $newBS" result]} {
			puts "Error on route add:\n$result"
		}
	}
	return 0
}

#
AnnounceListenManager/RoutingTableAgent private NSLookup {name} {
    set firstchar [string index $name 0]
    if [string match \[a-zA-Z\] $firstchar] {
	return [gethostbyname $name]
    } else {
	return $name
    }
}

#
## ---  just start the agent in lieu of embedding in an application
#
set netObj [new AnnounceListenManager/RoutingTableAgent 4096 127.0.0.1/3443]

# run a tk event loop in tclsh
vwait forever

