# ui-browsetime.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#   @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mb/ui-browsetime.tcl,v 1.4 2002/02/03 04:27:17 lim Exp $


Class MBTimePanel

MBTimePanel instproc init {parent} {
	$self instproc path_ slider_ timeLabel_ stopBut_ playBut_
	set path_ [frame $parent.ts]
	set slider_ [scale $path_.slider -orient horizontal \
			-from 0 -to 10000 -relief groove -borderwidth 1 \
			-showvalue false -command "$self updateLabel"]
	#
	# We want slightly different semantics.  Instead of tracking
	# the time slider continuously, we just update it when the
	# button is released. (but we use updateTime to give feedback to the
        # user
	# E.g., it takes too long to do a fast-forward each time.
	#
        bind $slider_ <Button-1> "$self wait"
        bind $slider_ <Button-2> "$self wait"

	bind $slider_ <ButtonRelease-1> "$self move2time"
	bind $slider_ <ButtonRelease-2> "$self move2time"

        pack $slider_ -side left -fill x

	set timeLabel_ [label $path_.timeL]
	set stopBut_ [button $path_.stopB -text stop -command "$self stop"]
	set playBut_ [button $path_.playB -text play -command "$self start"]
	pack -side left $timeLabel_ $stopBut_ $playBut_ -fill x
}

MBTimePanel instproc formatTime {time} {
	clock format $time "%h:%M:%S $p"
}

MBTimePanel instproc minTime {time} {
	$self set mintime_ $time
}

MBTimePanel instproc maxTime {time} {
	$self set maxtime_ $time
}

MBTimePanel instproc pack {args} {
	eval pack $args [$self set path_]
}

MBTimePanel instproc unpack {} {
	pack forget [$self set $path_]
}

MBTimePanel instproc updateCallBack {cmd} {
	$self set updateCallBack_ $cmd
}

MBTimePanel instproc setTime {val} {
	$self instvar updateCallBack_
	set newtime [expr {$mintime_ + ($x/10000.0)*($maxtime_ - $mintime_)}]
	eval $updateCallBack_ $newtime
}

MBTimePanel instproc updateLabel {x} {
	$self instvar timeLabel_
	$self set sliderVal $x
	set newtime [expr {$mintime_ + ($x/10000.0)*($maxtime_ - $mintime_)}]
	$timeLabel_ configure -text [$self formatTime newtime]
}

MBTimePanel instproc move2time {x} {
	set newtime [expr $mintime_ + ($x/10000.0)*($maxtime_ - $mintime_)]
	$self setTime $x
}

