# application-megatest.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/megatest/application-megatest.tcl,v 1.8 2002/02/03 04:27:46 lim Exp $

#import Application AnnounceListenManager/MeGa/Client/Video Network
import Application AnnounceListenManager/MeGa/Client Network

Class MeGaTester -superclass Application

MeGaTester public init argv {
	$self next megatester

	set o [$self options]
	$self init_args $o
	$self init_resources $o
	$o parse_args $argv
	$self init_local

	$self init_test
}

MeGaTester private init_args o {
	$self next $o

	$o register_boolean_option -diff diffSession

	$o register_option -ngw gwNum
	$o register_option -int interval
	$o register_option -megactrl megaCtrl
	$o register_option -maxsbw maxSessionBW
	$o register_option -unicast unicast
}

MeGaTester private init_resources o {
	$self next $o

	# MeGa Resources
	$o add_default megaCtrl 224.4.5.24/50000/1
	# multicast is default
	$o add_default megaRecvPort 0

	# (scuba) default session bandwidth (kb/s).
	$o add_default maxSessionBW 1000000

	# 60 seconds max startup wait for first message
	$o add_default megaStartupWait 60

	$o add_default interval 5000
	$o add_default gwNum 1
}

MeGaTester private init_test {} {

	$self instvar int_ gwnum_  port_ specs_
	set int_ [$self get_option interval]
	set gwnum_ [$self get_option gwNum]
	set port_ 10000
	set specs_ 5000

	set i 0
	while { $i < $gwnum_ } {
		after [expr int($i*$int_+0.5)] "$self start_client $i"
		incr i
	}
}

MeGaTester private start_client id {
	$self instvar port_ clients_ specs_

	if { [$self get_option unicast] == "" } {
		set rportspec 0
		set megaspec [$self get_option megaCtrl]
	} else {
		set ctrlrport [expr $port_ + 2]
		set rportspec $port_:$ctrlrport
		incr port_ 4
		set addr [intoa [lookup_host_addr [$self get_option unicast]]]
set megaspec [$self get_option megaCtrl]
#		set megaspec $addr/60000:$ctrlrport/1
	}
	if { [$self get_option diffSession] != "" } {
		incr specs_ 1
	}
	set sname test:$specs_:0:IN:IP4:test
	set a [expr 10 + (($specs_ / (256*256)) % 256)]
	set b [expr ($specs_ / 256) % 256]
	set c [expr $specs_ % 256]
	set sspec 224.$a.$b.$c/4444/1
	puts "new TestClient $sname $sspec $megaspec $rportspec"
	set clients_($id) [new TestClient $sname $sspec $megaspec $rportspec]
}

Class TestClient

TestClient public init { sname sspec megaspec rportspec } {
	$self next

	$self instvar al_ sessionbw_
	set sessionbw_ [$self get_option maxSessionBW]
	set bw [expr 0.02*$sessionbw_]
	set al_ [new AnnounceListenManager/MeGa/Client $self $self \
			$megaspec $bw megatest sdp $sname $sspec \
			$rportspec h261 ]
	$al_ start 1
}

TestClient private reset_spec s {
	$self instvar cn_ dn_

	set s [split $s /]
	set addr [lindex $s 0]
	set ports [split [lindex $s 1] :]
	set sport [lindex $ports 0]
	set rport [lindex $ports 1]
	set ttl [lindex $s 3]
	set dn_ [new Network]
	$dn_ open $addr $sport $rport $ttl
	set cn_ [new Network]
	$cn_ open $addr [expr $sport + 1] [expr $rport + 1] $ttl
}

TestClient private have_network {} {
	$self instvar dn_
	return [info exists dn_]
}

TestClient private session-addr {} {
	$self instvar dn_
	if ![$self have_network] {
		return none
	}
	return [$dn_ addr]
}

TestClient private session-sport {} {
	$self instvar dn_
	if ![$self have_network] {
		return none
	}
	return [$dn_ sport]
}

TestClient private session-rport {} {
	$self instvar dn_
	if ![$self have_network] {
		return none
	}
	return [$dn_ rport]
}

TestClient private session-ttl {} {
	$self instvar dn_
	if ![$self have_network] {
		return none
	}
	return [$dn_ ttl]
}
