# back_end_starter.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

proc DoConnect {fd addr port} {
    fileevent $fd readable "DoRead $fd";
}

proc DoRead {fd} {
    set count [gets $fd nline];
    if {$count > -1} {
	if {[lindex $nline 0] == "start"} {
	    global smash_loc
	    global pid_map
	    global back_end_prog
	    puts "Starting new back end..."
	    set pid_map($fd) [eval exec glurun $smash_loc $back_end_prog [lrange $nline 1 end] &]
	}
    } else {
	global pid_map
	puts "Killing back end"
	catch "exec kill -9 $pid_map($fd)"
	close $fd;
    }
}

set smash_loc /home/cs/kpatel/mash-code/mash/bin/smash
set back_end_prog /home/cs/kpatel/mash-code/mash/tcl/psvp/fx_forward/back_end.tcl
set port 20004

for {set i 0} {$i < [llength $argv]} {incr i} {
    set arg [lindex $argv $i];

    if {$arg == "-port"} {
	incr i;
	set port [lindex $argv $i];
    }
    incr i;
}

set fd [socket -server DoConnect $port];

if {![info exists tk_version]} {
    vwait forever
}
