# application-rvic-cl.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import Application RvicClientUI RendezvousManager

#
# application wrapper for RvicClientUI -- deal with cmd line
# args and spawn it appropriately
#
Class RvicClientApp -superclass Application


# start up a RvicClientUI.  Three init styles:
# <br> 1) -ctrl `ctrl_addr_spec' -- attaches to server at
#         `ctrl_addr_spec' directly
# <br> 2) -rendez `rendez_addr_spec' -- listens for any server on
#         `rendez_addr_spec' and attaches to whatever is found
# <br> 3) -rendez `rendez_addr_spec' `session_addr_spec' -- attaches to
#         a server connected to video session `session_addr_spec' by
#         listening on `rendez_addr_spec'
#
RvicClientApp public init {argv} {
	$self next rvicClient
	$self instvar rvMgr_

	set o [$self options]
	$o register_option -rendez rendezSpec
	$o register_option -ctrl ctrlSpec
	#$o add_default rendezSpec 230.5.6.7/8888
	set argv [$o parse_args $argv]

	if {[llength $argv] > 1} {
		$self show_usage
	}


	set ctrl [$self get_option ctrlSpec]
	if {$ctrl == ""} {
		# need to listen for and find ctrl address
		set rendez [$self get_option rendezSpec]
		if {$rendez == ""} {
			$self show_usage
		} else {
			set rvMgr_ [new RendezvousManager $rendez]
			set session_spec ""
			if {[llength $argv] == 1} {
				# the arg is the session address
				# which this RvicClient wants to find a
				# RvicServer for
				set session_spec $argv
			}
			set ctrl [$self find_ctrl_addr $session_spec]
			if {$ctrl == ""} {
				puts "Error: Timeout occured: No RvicServer can be found"
				exit
			} else {
				puts "RvicServer found at addr $ctrl... connecting."
			}
		}
	}

	set ui_ [new RvicClientUI "" $ctrl]

}

#
RvicClientApp private find_ctrl_addr {{session ""}} {
	$self instvar rvMgr_ listen_timer_
	if ![info exists listen_timer_] {set listen_timer_ 0}

	set query "will-provide: & mash-object=RemoteVicApplication"
	if {$session != ""} {
		append query " & spec=$session"
	}
	set response [$rvMgr_ query $query]
	if {$response == ""} {
		if {$listen_timer_ > 12000} {
			return ""
		}
		incr listen_timer_ 3000
		puts "Can't find an RvicServer... still trying..."
		update
		after 3000
		update
		return [$self find_ctrl_addr $session]
	} else {
		unset listen_timer_
		set ctrl [$response get_field ctrlspec]
		return $ctrl
	}
}


# print usage info and exit
RvicClientApp private show_usage {} {
	global argv0
	puts "Usage:"
	puts " $argv0 -ctrl ctrl_addr_spec"
	puts " $argv0 -rendez rendez_addr_spec"
	puts " $argv0 -rendez rendez_addr_spec session_addr_spec"
	set o [$self options]
	foreach arg [$o arg_info] {
		puts $arg
	}
	exit
}


