# manager-srmv2.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# Check that the address specification <i>argv</i> is valid and present
# (if needed).  Returns its argument.
#
SRMv2_Manager private check_hostspec { argv } {
        $self instvar name_
        if { $argv == "" } {
                if { [$self get_option megaSession] == "" } {
                        $self fatal "destination address required"
                }
        } elseif { [llength $argv] > 1 } {
                set extra [lindex $argv 0]
                $self fatal "extra arguments (starting with $extra)"
        }
        return $argv
}

SRMv2_Manager instproc parse_epilog { argv } {
        $self instvar name_

        if { $argv == "" } {
                if { [$self get_option defaultHostSpec] == "" && \
				[$self get_option megaSession] == "" } {
                        puts stderr "$name_: destination address required"
                        exit 1
                }
        } elseif { [llength $argv] > 1 } {
                set extra [lindex $argv 0]
                puts stderr "$name_: extra arguments (starting with $extra)"
                exit 1
        } else {
                $self add_option defaultHostSpec $argv
        }
}

SRMv2_Manager instproc create-session { } {
	$self instvar bpool_ lsrc_ session_
        set session_ [new Session/SRMv2]
	set bpool_ [new BufferPool/SRMv2]
	set lsrc_ [$session_ create-local-source "[exec whoami]@[info hostname]"]
	$bpool_ srmv2-source $lsrc_
	$session_ buffer-pool $bpool_
}

SRMv2_Manager instproc reset { ab } {
	$self instvar network_ session_

	if [info exists network_] {
		delete $network_
	}
	set network_ [new NetworkManager $ab $session_ $self]
	set key [[Application instance] get_option sessionKey]
	if { $key != "" } {
		$network_ install-key $key
	}
}

SRMv2_Manager instproc set_maxchannel { n } { }

SRMv2_Manager instproc application {app} {
	$self instvar application_
	set application_ $app
}

#
# Hand over named data buffer to the application
#
SRMv2_Manager instproc recv { nm seqno blk } {
	$self instvar application_
	$application_ handle $nm $seqno $blk
}

SRMv2_Manager instproc reada { nm seqno } {
	$self instvar application_
	return [$application_ reada $nm $seqno]
}


SRMv2_Manager instproc recover { nm start end } {
	$self instvar application_
	return [$application_ recover $nm $start $end]
}

SRMv2_Manager instproc get-adu { nm seqno } {
	$self instvar application_
	return [$application_ get-adu $nm $seqno]
}

SRMv2_Manager instproc enqueue { nm seqno ss es } {
	$self instvar application_
	return [$application_ enqueue $nm $seqno $ss $es]
}

