# al-client-ssac.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/ssac/al-client-ssac.tcl,v 1.15 2002/02/03 04:30:10 lim Exp $


import AnnounceListenManager/AS/Client Application

#  This class is used in implementing the archive client application, rover
#  <p> Current status: alpha
#  <p> Author: Angela Schuett


Class AnnounceListenManager/AS/Client/SSAC -superclass \
		AnnounceListenManager/AS/Client



AnnounceListenManager/AS/Client/SSAC instproc init {client megactrl ssg_port \
		{srv_loc {}} {bw 500} } {
	$self instvar client_ service_instance_ ssg_port_ ssd_
	if { $srv_loc == {} } { set srv_loc "static:mars" }
	$self next $megactrl $bw $srv_loc

	set service_instance_ "[pid]:[localaddr]:mars"
	set ssg_port_ $ssg_port
	set client_ $client
	$self set_seqno 1

	set ssd_(localaddr) [localaddr]
}


AnnounceListenManager/AS/Client/SSAC instproc service_name {} {
	#puts "service_name"
	return Mars
}

AnnounceListenManager/AS/Client/SSAC instproc service_instance {} {
	$self instvar service_instance_
	return $service_instance_
}

AnnounceListenManager/AS/Client/SSAC instproc agent_data {} {
    #puts "agent_data"
    $self instvar ssd_ broadcast_

    set msg ""
    append msg "Seqno $ssd_(seqno)\n"
    append msg "Filename $ssd_(filename)\n"
    append msg "Offset $ssd_(offset)\n"
    append msg "ClientAddr $ssd_(localaddr)\n"
    append msg "UnicastPort $ssd_(unicast_port)\n"

    # now put in the broadcast
    foreach {key value} [array get broadcast_] {
	append msg "inetBroadcastAddr $key:$value\n"
    }

#    puts "msg = $msg;"

    return $msg
}


AnnounceListenManager/AS/Client/SSAC instproc set_filename {filename} {
	$self instvar ssd_
	set ssd_(filename) $filename
}

AnnounceListenManager/AS/Client/SSAC instproc data_multicast {flag} {
	$self instvar ssd_ ssg_port_
	if { $flag == 0 && $ssg_port_ != "-" } {
		set ssd_(unicast_port) [expr $ssg_port_ + 2]
	} else {
		set ssd_(unicast_port) 0
	}
}


AnnounceListenManager/AS/Client/SSAC instproc set_offset {offset} {
	$self instvar ssd_
	set ssd_(offset) $offset
}


AnnounceListenManager/AS/Client/SSAC instproc set_seqno {seqno} {
	$self instvar ssd_
	set ssd_(seqno) $seqno
}

AnnounceListenManager/AS/Client/SSAC instproc seqno {} {
	$self instvar ssd_
	return $ssd_(seqno)
}


AnnounceListenManager/AS/Client/SSAC instproc register { atype aspec addr \
		srv_name srv_inst msg } {
}


AnnounceListenManager/AS/Client/SSAC instproc unregister { atype aspec addr \
		srv_name srv_inst msg } {
}


AnnounceListenManager/AS/Client/SSAC instproc recv_msg { atype aspec addr \
		srv_name srv_loc srv_inst ssg_port msg } {
	$self instvar client_ service_instance_
	if {$srv_inst != $service_instance_} {
		return
	}

	if {[string length $msg] > 0} {
		$client_ notify $msg
	}

}

AnnounceListenManager/AS/Client/SSAC instproc ssg_port {} {
	$self instvar ssg_port_
	return $ssg_port_
}

AnnounceListenManager/AS/Client/SSAC instproc set_broadcast {lbroadcast} {
    $self instvar broadcast_
    array set broadcast_ $lbroadcast
}

