# ui-toolbar.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#
# WidgetClass ToolBar
# configure options:
#    -orient (vertical/horizontal)
#    -style (imagetext/image/text)
#    -padx  (a number)
#    -pady  (a number)
#
# methods
#    apply
#    insert
#    remove
#    delete
#


import WidgetClass


WidgetClass ToolBar -configspec {
	{ -orient orient Orient vertical config_option }
	{ -style style Style imagetext config_option }
	{ -padx padX PadX 1 config_option }
	{ -pady padY PadY 1 config_option }
} -default {
	{ *ImageTextButton.orient vertical }
}


ToolBar instproc build_widget { path } {
	$self instvar config_
	set config_(-orient) vertical
	set config_(-style) imagetext
	set config_(-padx) 1
	set config_(-pady) 1
}


ToolBar instproc config_option { option args } {
	$self instvar config_
	if { [llength $args]==0 } {
		return $config_($option)
	} else {
		set config_($option) [lindex $args 0]
		$self config_[string range $option 1 end]_ $config_($option)
	}
}


ToolBar instproc config_orient_ { value } {
	switch -exact -- $value {
		vertical {
			$self apply all "pack configure %W -side top -fill x"
		}
		horizontal {
			$self apply all "pack configure %W -side left -fill y"
		}
		default {
			error "invalid argument \"$value\" to -orient"
		}
	}

}


ToolBar instproc config_style_ { value } {
	$self apply ImageTextButton "%W configure -style $value"
}


ToolBar instproc config_padx_ { value } {
	$self apply all "pack configure %W -padx $value"
}


ToolBar instproc config_pady_ { value } {
	$self apply all "pack configure %W -pady $value"
}


ToolBar instproc config_orient__ { value } {
	switch -exact -- $value {
		vertical {
			set pack_args "-side top -fill x"
		}
		horizontal {
			set pack_args "-side left -fill y"
		}
		default {
			error "invalid argument \"$value\" to -orient"
		}
	}

	foreach widget [pack slaves [$self info path]] {
		eval pack configure [list $widget] $pack_args
	}
}


ToolBar instproc config_style__ { value } {
	foreach widget [pack slaves [$self info path]] {
		if { [winfo class $widget]=="ImageTextButton" } {
			$widget configure -style $value
		}
	}
}


ToolBar instproc config_padx__ { value } {
	foreach widget [pack slaves [$self info path]] {
		pack configure $widget -padx $value
	}
}


ToolBar instproc config_pady__ { value } {
	foreach widget [pack slaves [$self info path]] {
		pack configure $widget -pady $value
	}
}


ToolBar instproc apply { cls command } {
	set list [pack slaves [$self info path]]
	if { $cls=="all" } {
		foreach widget $list {
			regsub -all -- %W $command "\{$widget\}" repl_cmd
			eval $repl_cmd
		}
	} else {
		foreach widget $list {
			if { $cls==[winfo class $widget] } {
				regsub -all -- %W $command "\{$widget\}" \
						repl_cmd
				eval $repl_cmd
			}
		}
	}
}


ToolBar instproc new_widget_ { } {
	$self instvar count_
	set path [$self info path]
	if { ![info exists count_] } { set count_ 0 }

	while [winfo exists $path.button_$count_] {incr count_}
	set widget $path.button_$count_
	incr count_
	return $widget
}


ToolBar instproc insert { where args } {
	set path [$self info path]
	set style [$self cget -style]
	switch -exact -- $where {
		end {
			set pack_args ""
		}

		after {
			if { [llength $args]==0 } {
				error "insufficient arguments to\
						ToolBar::insert"
			}

			set widget [string trim [lindex $args 0]]
			if { [string index $widget 0]!="." } {
				set widget "$path.$widget"
			} elseif { [winfo parent $widget]!=$path } {
				error "widget $widget must be a child of $path"
			}

			set pack_args "-after $widget"
			set args [lrange $args 1 end]
		}

		before {
			if { [llength $args]==0 } {
				error "insufficient arguments to\
						ToolBar::insert"
			}

			set widget [string trim [lindex $args 0]]
			if { [string index $widget 0]!="." } {
				set widget "[$self info path].$widget"
			} elseif { [winfo parent $widget]!=$path } {
				error "widget $widget must be a child of $path"
			}

			set pack_args "-before $widget"
			set args [lrange $args 1 end]
		}

		default {
			error "invalid argument \"$where\". must be one of\
					\"end\", \"after\", or \"before\""
		}
	}

	switch -exact -- [$self cget -orient] {
		vertical {
			append pack_args " -side top -fill x"
		}
		horizontal {
			append pack_args " -side left -fill y"
		}
	}
	append pack_args " -padx [$self cget -padx] -pady [$self cget -pady]"

	set list ""
	foreach widget $args {
		set more_args ""
		if { [llength $widget]==1 && \
				[lsearch -exact "separator sep endalign" \
				[lindex $widget 0]]==-1 } {
			# this is a widget name
			set widget [lindex $widget 0]
			if { [string index $widget 0]!="." } {
				set widget "[$self info path].$widget"
			} elseif { [winfo parent $widget]!=$path } {
				error "widget $widget must be a child of $path"
			}
		} else {
			# we must create a new widget

			set widget_args $widget
			set widget [$self new_widget_]
			set first [lindex $widget_args 0]
			if { $first=="separator" || $first=="sep" } {
				set widget_args [lrange $widget_args 1 end]
				if { [lsearch -exact $widget_args \
						"-width"]==-1 } {
					lappend widget_args -width 15
				}
				if { [lsearch -exact $widget_args \
						"-height"]==-1 } {
					lappend widget_args -height 15
				}

				eval frame [list $widget] $widget_args
			} elseif { $first=="endalign" } {
				set widget_args [lrange $widget_args 1 end]
				eval frame [list $widget] $widget_args
				set more_args "-expand 1"
			} else {

				# $widget is actually the list of arguments to
				# ImageTextButton

				eval ImageTextButton [list $widget] \
						$widget_args
			}
		}

		lappend list $widget
		if { [winfo class $widget]=="ImageTextButton" } {
			$widget configure -style $style
		}
		eval pack [list $widget] $pack_args $more_args
	}

	return $list
}


ToolBar instproc delete_ { action args } {
	set list ""
	set path [$self info path]
	foreach widget $args {
		if { [string index $widget 0]=="." } {
			set widget $path.$widget
		} elseif { [winfo parent $widget]!=$path } {
			error "widget $widget must be a child of $path"
		}

		eval $action [list $widget]
		lappend list $widget
	}
	return $list
}


ToolBar instproc delete { args } {
	eval [list $self] delete_ destroy $args
}


ToolBar instproc remove { args } {
	eval [list $self] delete_ {{pack forget}} $args
}
