# ui-sitebox.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vat/ui-sitebox.tcl,v 1.7 2002/02/03 04:30:33 lim Exp $


#
# Define a constructor to set up some extra state.
# (most of this object is implemented in misc/sitebox.cc)
#
Sitebox instproc init { path agent } {
	# setting some resources for c++ code to use
	$self add_default siteFont [$self get_option helv12b]
	# use the default colors if we are in windows
	global tcl_platform
	if {$tcl_platform(platform) != "windows"} {
		# Sitebox gets these from mash rather than tk
		$self add_default background gray85
	}
	$self add_default disabledColor gray50
	$self add_default highlightColor gray95

	$self next $path
	$self instvar path_ agent_
	set path_ $path
	set agent_ $agent

	$self bind <1> "$self leftclick %x %y 0"
	$self bind <Shift-1> "$self leftclick %x %y 1"
	$self bind <2> "$self midclick %x %y 0"
	$self bind d "$self delete_source %x %y"
}

#
Sitebox instproc bind { template action } {
	$self instvar path_
	bind $path_ $template $action
}

#FIXME update this comment
# a sitebox responds to the following commands:
#  sites			- returns current no. of sites
#  purge			- purges inactive sites
#  sort				- sorts sitebox
#  list				- lists sites on stdout
#  name localname		- sets local site name to 'localname'
#  keepsites 0|1		- set/reset 'keep all sites' option
#  mutesites 0|1		- set/reset 'mute new sites' option
#  keepsorted 0|1		- set/reset 'keep sites sorted' option
#  keepcompact 0|1		- set/reset 'keep sitebox comapacted' option
#  withID id			- return index of site with id <id>
#  IDtoName id			- return name of site with id <id>
#  which x y			- return number of site at location (x,y)
#				  (-1 if none)
#  where x y			- return where in site is (x,y) (0 = name,
#				  1 = mute checkbox).
#  site n info			- return site n name, id & packet src id
#  site n name			- return site name
#  site n activity		- return time of last activity
#  site n lastactive		- return number of milliseconds since
#				  site n was last active (-1 if never
#				  active).
#  site n muted			- return 1 if site n muted, 0 otherwise
#  site n toggle		- toggle site n mute state
#  site n mute 0|1		- set/reset site n mute state

#
Sitebox instproc leftclick {x y m} {
	set s [$self which $x $y]
	if {"$s" != ""} {
		if [$self over-button $x $y] {
			#
			# toggle the mute button
			# update both the UI and the RTP object
			#
			$s toggle-mute
		} else {
			$self instvar path_
		        set rootx [expr [winfo rootx $path_] + $x]
		        set rooty [expr [winfo rooty $path_] + $y]
			$s build-info-menu $path_.m $rootx $rooty $self
		}
	}
}

#
Sitebox instproc delete_source { x y } {
	$self instvar agent_
	set srcName [$self which $x $y]
	if { "$srcName" != "" } {
		set src [$srcName source]
		if { $src != [$agent_ local] } {
			#
			# delete the source via the agent
			# eventually, the UI gets called back
			# and notified that the source was deleted,
			# so we do nothing more here
			#
			$agent_ delete $src
		}
	}
}

#
Sitebox instproc midclick {x y m} {
	set srcName [$self which $x $y]
	if {"$srcName" != ""} {
		set src [$srcName source]
		if [$src is_mixer] {
			set s [$src getid]
			open_dialog \
			  "can't do side conversation with $s thru mixer"
		} else {
			set fmt [$src format_name]
			if { $fmt == "" } {
				set fmt pcm2
			}
			$self instvar agent_
			set csig [$src addr]/[$agent_ session-port]
			if { [$self get_option sessionType] == "vat" } {
				set confid [$self get_option confid]
				exec vat -r -C [$src getid] -confid $confid \
						$csig/$fmt &
			} else {
				puts "vat -C [$src getid] $csig/$fmt &"
				exec vat -C \"[$src getid]\" $csig/$fmt &
			}
		}
	}
}

#
Sitebox instproc purge {} {
	$self instvar agent_
	$agent_ gen-init
	while { 1 } {
		set src [$agent_ gen-next]
		if { $src == "" } {
			return
		}
		if [$src lost] {
			$agent_ delete $src
		}
	}
}

#
Sitebox instproc list {} {
	$self instvar agent_
	$agent_ gen-init
	while { 1 } {
		set src [$agent_ gen-next]
		if { $src == "" } {
			return
		}
		if [$src lost] {
			set lost "*"
		} else {
			set lost ""
		}
		set fmt "[$src getid] \[[$src addr]/[$src srcid]"
		if [$src is_mixer] {
			set fmt "$fmt via [$src ssrc]"
		}
		set fmt "$fmt\]"
		puts $lost$fmt
	}
}

