# application-aswitch.tcl --
#
#       Creates an AutoSwitch object and gives it a frame to display in
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import Application AutoSwitch

Class AutoSwitchApplication -superclass Application

AutoSwitchApplication instproc showUsage {} {
   puts stdout "usage:  aswitch \[-cf <config file>\]"
}

AutoSwitchApplication instproc getFlags {argv} {
    $self instvar configFile_

    set configFile_ ""

    set state flag
    foreach arg $argv {
	switch -exact -- $state {
	    flag {
		switch -exact -- $arg {
		    -cf {
			set state "cf"
		    }
		    -help {
			$self showUsage
			exit
		    }
		    default {
			$self showUsage
			exit
		    }
		}
	    }
	    cf {
		set configFile_ $arg
		set state "flag"
	    }
	}
    }
}

AutoSwitchApplication instproc init {argv} {
    $self instvar as_ configFile_
    $self next $argv

    $self getFlags $argv

    $self initUI

    set as_ [new AutoSwitch .asFrame $configFile_]
}

AutoSwitchApplication instproc initUI {} {
    wm title . "AutoSwitch"
    wm minsize . 200 100

    # make auto switch frame
    frame .asFrame
    pack .asFrame -side top

    # FIXME - test buttons
    button .enable -text "Enable" -command "$self enableAutoSwitch"
    pack .enable
    button .disable -text "Disable" -command "$self disableAutoSwitch"
    pack .disable
    button .test -text "Test" -command "$self testProc"
    pack .test

    # make exit button
    button .exit -text "Exit" -command "$self exitApp"
    pack .exit -side bottom
}

AutoSwitchApplication instproc exitApp {} {
    $self instvar as_

    exit
}

AutoSwitchApplication instproc enableAutoSwitch {} {
    $self instvar as_

    $as_ enable
}

AutoSwitchApplication instproc disableAutoSwitch {} {
    $self instvar as_

    $as_ disable
}

AutoSwitchApplication instproc testProc {} {
    $self instvar as_

    $as_ setOutput htsr2
}
