# application-rqmc.tcl --
#
#       Creates a RemoteQuestionMonitorClient to talk to a remote QM
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import Application RemoteQuestionMonitorClient

Class RemoteQuestionMonitorClientApplication -superclass Application

RemoteQuestionMonitorClientApplication instproc showUsage {} {
    puts stdout "usage:  rqm \[-port\] \[-host\]"
}

RemoteQuestionMonitorClientApplication instproc getFlags { argv } {
    $self instvar port_ hostname_

    set state flag
    foreach arg $argv {
        switch -exact -- $state {
            flag {
                switch -exact -- $arg {
                    -port {
                        set state "port"
                    }
		    -host {
                        set state "host"
                    }
                    -help {
                        $self showUsage
                        exit
                    }
                    default {
                        $self showUsage
                        exit
                    }
                }
            }
	    port {
		set port_ $arg
		set state "flag"
	    }
	    host {
		set hostname_ $arg
		set state "flag"
	    }
	}
    }
}

RemoteQuestionMonitorClientApplication instproc init { argv } {
    $self instvar rqmc_ port_ hostname_

    set hostname_ garfield.cs.berkeley.edu
    set port_ 6903

    $self next "remoteQuestionMonitorClient"

    $self getFlags $argv

    $self initUI

    # args are: baseFrame, withGui
    if {[catch {set rqmc_ [new RemoteQuestionMonitorClient ".rqmcFrame" $hostname_ $port_]} err]} {
	puts stderr "$err"
	exit
    }
}

RemoteQuestionMonitorClientApplication instproc initUI {} {
    wm title . "Remote Question Monitor Client"
    wm minsize . 200 0

    frame .rqmcFrame -borderwidth 3 -relief sunken
    pack .rqmcFrame -side top

    # make exit button
    button .exit -text "Exit" -command "$self exitApp"
    pack .exit -side bottom
}

RemoteQuestionMonitorClientApplication public exitApp {} {
    $self instvar rqmc_

    $rqmc_ destroy

    exit
}
