#!/usr/sww/bin/perl

# doeval.pl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

if(!defined($cmd=$ARGV[0]))
{
    showUsage();
}
if(!defined($dataDir=$ARGV[1]))
{
    showUsage();
}
if(!defined($rangeFile=$ARGV[2]))
{
    $rangeFile = "ranges.txt";
}

# defaults
$histSize = 50;
$timeSlice = 250;

# commands
$evaluate = "../utils/evalnonew";

# get the ranges we want
open(INFILE, $rangeFile);
$val = <INFILE>;
chomp($val);
@speakerThresholds = split(/ /, $val);
$val = <INFILE>;
chomp($val);
@leftThresholds = split(/ /, $val);
$val = <INFILE>;
chomp($val);
@centerThresholds = split(/ /, $val);
$val = <INFILE>;
chomp($val);
@rightThresholds = split(/ /, $val);
$val = <INFILE>;
chomp($val);
@histSizes = split(/ /, $val);
$sizeST = $#speakerThresholds + 1;
$sizeLT = $#leftThresholds + 1;
$sizeCT = $#centerThresholds + 1;
$sizeRT = $#rightThresholds + 1;
$sizeHS = $#histSizes + 1;
close(INFILE);

if($cmd eq "overall")
{
    # read the weights from the weights.txt file
    $weightsFile = "./weights.txt";
    open(INFILE, $weightsFile);
    for($x = 0; $x < 5; ++$x)
    {
	$val = <INFILE>;
	chomp($val);
	$weights[$x] = $val;
	$cmd = "$cmd $val";
    }
    close(INFILE);
}

for($p = 0; $p < $sizeHS; $p++)
{
    $histSize = $histSizes[$p];
    for($w = 0; $w < $sizeST; $w++)
    {
	$st = $speakerThresholds[$w];
	for($y = 0; $y < $sizeCT; $y++)
	{
	    $ct = $centerThresholds[$y];
	    for($z = 0; $z < $sizeRT; $z++)
	    {
		$rt = $rightThresholds[$z];
		for($x = 0; $x < $sizeLT; $x++)
		{
		    $lt = $leftThresholds[$x];

		    # actual stuff
		    $result = system "$evaluate $cmd $dataDir/analyze.$st.$lt.$ct.$rt.$histSize.$timeSlice.stats";
		    puts(" $st.$lt.$ct.$rt.$histSize.$timeSlice\n");
		}
	    }
	}
    }
}

# subroutines

sub puts
{
    $arg0 = $_[0];

    system("printf \'$arg0\'");
}

sub showUsage
{
    print("Usage: doeval <command> <data directory> [<range file>]\n");
    exit;
}

