# sim2area.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_infile g_index g_end g_prevMode g_areas

proc init {argv} {
    global g_infile g_index g_end g_prevMode g_areas

    if {([llength $argv] != 2)} {
	puts stdout "Usage: sim2area <sim.out file> <end>"
	exit
    }

    set g_areas(speaker) 0
    set g_areas(left) 0
    set g_areas(center) 0
    set g_areas(right) 0

    set g_infile [lindex $argv 0]
    set g_index 0
    set g_prevMode "speaker"
    set g_end [lindex $argv 1]
}

proc makeOutfile {} {
    global g_infile g_index g_end g_prevMode g_areas

    if {[catch {open $g_infile r} infile]} {
        puts stdout "Cannot open file $g_infile for reading"
        return 0
    }

    while {[gets $infile line] >= 0} {
	set sLine [split $line " "]
	set index [lindex $sLine 0]
	set mode [lindex $sLine 1]
	processEntry $index $mode
    }

    set realMode [translate "speaker"]
    set diff [expr $g_end - $g_index]
    incr g_areas($realMode) $diff
    set g_index $g_end

    close $infile

    set pct(speaker) [expr double($g_areas(speaker)) / double($g_end)]
    set pct(left) [expr double($g_areas(left)) / double($g_end)]
    set pct(center) [expr double($g_areas(center)) / double($g_end)]
    set pct(right) [expr double($g_areas(right)) / double($g_end)]

#    puts stdout "speakerArea $g_areas(speaker)"
#    puts stdout "leftArea $g_areas(left)"
#    puts stdout "centerArea $g_areas(center)"
#    puts stdout "rightArea $g_areas(right)"

    puts stdout "pctSpeakerArea $pct(speaker)"
    puts stdout "pctLeftArea $pct(left)"
    puts stdout "pctCenterArea $pct(center)"
    puts stdout "pctRightArea $pct(right)"
}

proc processEntry {index mode} {
    global g_infile g_index g_end g_prevMode g_areas

    # an entry means the previous mode has completed
    switch -exact -- $mode {
	speaker -
	audienceLeft -
	audienceCenter -
	audienceRight {
	    set realMode [translate $g_prevMode]
	    set diff [expr $index - $g_index]
	    incr g_areas($realMode) $diff
	    set g_index $index
	    set g_prevMode $mode
	}
    }
}

proc translate {mode} {
    switch -exact -- $mode {
	speaker {
	    return "speaker"
	}
	audienceLeft {
	    return "left"
	}
	audienceCenter {
	    return "center"
	}
	audienceRight {
	    return "right"
	}
    }
}

# main program

init $argv

makeOutfile

