# amxtest.tcl --
#
#       For debugging, allows you to send arbitrary commands to amx
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_app

Import enable

import Application DpClient

Class AmxTestApp -superclass Application

AmxTestApp instproc init {argv} {
    $self instvar amx_

    $self next $argv
    $self initUI
#    $self initAmx garfield.cs.berkeley.edu 6901
    $self initAmx htsr.bmrc.berkeley.edu 6901
}

#
# GUI stuff
#

AmxTestApp instproc initUI {} {
    $self instvar comText_ devText_ chanText_ strText_ cmd_ dev_ chan_ str_

    wm title . "AmxTest"
    wm minsize . 150 0

    frame .entry
    pack .entry -side top -pady 10

    label .entry.commandLabel  -text "command"
    pack .entry.commandLabel -side left
    set comText_ [text .entry.commandText -width 4 -height 1]
    pack .entry.commandText -side left
    $comText_ insert 0.0 "4"

    label .entry.deviceLabel  -text "device"
    pack .entry.deviceLabel -side left
    set devText_ [text .entry.deviceText -width 4 -height 1]
    pack .entry.deviceText -side left
    $devText_ insert 0.0 "5"

    label .entry.channelLabel  -text "channel"
    pack .entry.channelLabel -side left
    set chanText_ [text .entry.channelText -width 4 -height 1]
    pack .entry.channelText -side left
    $chanText_ insert 0.0 "133"

    label .entry.stringLabel -text "string"
    pack .entry.stringLabel -side left
    set strText_ [text .entry.strText -width 25 -height 1]
    pack .entry.strText -side left
    $strText_ insert 0.0 "A"

    frame .but
    pack .but -side top -pady 10

    button .but.send -text "Send AMX" -command "$self sendAmx"
    pack .but.send -side left
    button .but.receive -text "Receive AMX" -command "$self getAmx"
    pack .but.receive -side left
    button .but.spoof -text "Spoof AMX" -command "$self spoofAmx"
    pack .but.spoof -side left

    button .kill -text "Kill Server and Exit" -command "$self killServer"
    pack .kill -side top

    button .test -text "Register" -command "$self execTest"
    pack .test -side top
    button .test5 -text "Unregister" -command "$self execTest5"
    pack .test5 -side top
    button .test2 -text "Disable" -command "$self execTest2"
    pack .test2 -side top
    button .test3 -text "Enable" -command "$self execTest3"
    pack .test3 -side top
    button .test4 -text "Test" -command "$self execTest4"
    pack .test4 -side top

    button .test20 -text "Register2" -command "$self execTest20"
    pack .test20 -side top
    button .test25 -text "Unregister2" -command "$self execTest25"
    pack .test25 -side top
    button .test22 -text "Disable2" -command "$self execTest22"
    pack .test22 -side top
    button .test23 -text "Enable2" -command "$self execTest23"
    pack .test23 -side top

    # make exit button
    button .exit -text "Exit" -command "$self exitApp"
    pack .exit -side bottom
}

AmxTestApp instproc initAmx { {hostname htsr.bmrc.berkeley.edu} {port 6901}} {
    $self instvar amx_

    if {[catch {new DpClient $hostname $port} amx_]} {
        puts stderr "Fatal error:  could not connext to AMX server"
	exit
    }
}

AmxTestApp instproc execTest {} {
    $self instvar amx_

    set result [$amx_ do callback_register getAmx]
    return $result
}

AmxTestApp instproc execTest2 {} {
    $self instvar amx_

    set result [$amx_ do callback_disable getAmx]
    return $result
}

AmxTestApp instproc execTest3 {} {
    $self instvar amx_

    set result [$amx_ do callback_enable getAmx]

    return $result
}

AmxTestApp instproc execTest4 {} {
    $self instvar amx_

    set result [$amx_ do amxd_getVersion]

    puts "amxd version = $result"

    if {$result == 1.0} {
	puts stdout "compatible version"
    } else {
	puts stdout "incompatible version"
    }

    for {set x 1} {$x < 16} {incr x 1} {
	set name [$amx_ do amx_deviceLookup $x]
	puts stdout "device $x is $name"
    }
    for {set x 128} {$x < 130} {incr x 1} {
	set name [$amx_ do amx_deviceLookup $x]
	puts stdout "device $x is $name"
    }

    return $result
}

AmxTestApp instproc execTest5 {} {
    $self instvar amx_

    set result [$amx_ do callback_unregister getAmx]
    return $result
}

AmxTestApp instproc execTest20 {} {
    $self instvar amx_

    set result [$amx_ do callback_register getAmx2]
    return $result
}

AmxTestApp instproc execTest22 {} {
    $self instvar amx_

    set result [$amx_ do callback_disable getAmx2]
    return $result
}

AmxTestApp instproc execTest23 {} {
    $self instvar amx_

    set result [$amx_ do callback_enable getAmx2]

    return $result
}

AmxTestApp instproc execTest25 {} {
    $self instvar amx_

    set result [$amx_ do callback_unregister getAmx2]
    return $result
}

proc gotIt {} {
    puts stdout "I got the command!"
}

AmxTestApp instproc killServer {} {
    $self instvar amx_

    $amx_ doNoWait "amxd_killServer"
    $self exitApp
}

AmxTestApp instproc exitApp {} {
    $self instvar amx_

    $amx_ closeRPC
    exit
}

AmxTestApp public spoofAmx {} {
    $self instvar amx_ cmd_ dev_ chan_ str_

    $self get_values
    set retval [$amx_ do spoofResponse $cmd_ $dev_ $chan_ $str_]
    puts stdout "spoof returns: $retval"
}

AmxTestApp public sendAmx {} {
    $self instvar amx_ dev_ chan_ cmd_ str_
    $self get_values

    switch -exact $cmd_ {
	1 -
	2 -
	3 -
	6 -
	7 -
	9 -
	10 -
	15 {
	    set retval [$amx_ do send-AMX-command $cmd_ $dev_ $chan_]
	}
	4 -
	5 {
	    set retval [$amx_ do send-AMX-command $cmd_ $dev_ $str_]
	}
	8 -
	11 {
	    set retval [$amx_ do send-AMX-command $cmd_ $dev_]
	}
	default {
	    # I just put this here for testing
	    catch {$amx_ do send-AMX-command $cmd_ $dev_ $chan_} retval
	}
    }
}

AmxTestApp private get_values {} {
    $self instvar comText_ devText_ chanText_ strText_ cmd_ dev_ chan_ str_

    set cmd_ 0
    set dev_ 0
    set chan_ 0
    set str_ ""

    set comStr [$comText_ get 1.0 1.end]
    scan $comStr "%d" cmd_
    set devStr [$devText_ get 1.0 1.end]
    scan $devStr "%d" dev_
    set chanStr [$chanText_ get 1.0 1.end]
    scan $chanStr "%d" chan_
    set str_ [$strText_ get 1.0 1.end]
#    puts stdout "str_ is $str_, length of it is [string length $str_]"
    set char [string index $str_ [expr [string length $str_] - 1]]
#    puts stdout "the last char is $char, it's asciival is [charToInt $char]"
}

proc getAmx { retList } {
    global g_app

#    puts stdout "getamx got $retList"
    puts stdout "getamx called:"

    $g_app processAmx $retList
}

proc getAmx2 { retList } {
    global g_app

#    puts stdout "getamx2 got $retList"
    puts stdout "getamx2 called:"

    $g_app processAmx $retList
}

AmxTestApp public processAmx { retList } {
    global g_app

    if {[llength $retList] != 0} {
	set eventInfo [lindex $retList 0]
	set type [lindex $eventInfo 0]
	set eventData [lindex $retList 1]
	set cmd [lindex $eventData 0]
	set dev [lindex $eventData 1]
	set chan_str [lindex $eventData 2]
	puts stdout "processAmx: received type=$type, cmd=$cmd, dev=$dev, chan_str=$chan_str"
    } else {
	puts stdout "processAmx: nothing received"
    }
    flush stdout
}


#
# driver engine
#

set g_app [new AmxTestApp $argv]

# next line is very important!!!
vwait forever

