# ui-main.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vic/ui-main.tcl,v 1.96 2002/02/03 04:39:55 lim Exp $


import ControlMenu VicHelpWindow HelpWindow Switcher \
	ActiveSourceManager VicAudioUI AudioPanel UISrcList \
	CuesReceiver Configuration VisualFrame mashutils CameraManager

#
# The main user interface for the vic application.
# <p>
# An interface to video streams... <br>
# Displays a panel of postage-stamp-sized video sources and their respective network statistics.
# By selecting a thumbnail, a resizable toplevel window will appear that can remain dedicated to
# displaying the selected source or can be configured to cycle through all the video sources
# in a designated manner (voice-switched, timer-switched, etc.).
#
# <p>
# Defaults:
# <br> geometry used to be 250x225
# <br> vain can be set to true to allow voice-switch to switch to self
Class VicUI -superclass Observer -configuration {
	minwidth 200
	minheight 100
	filterGain 0.25
	geometry {}
	vain false
}

#
# Takes a frame, <i>w</i>, and create and pack within it the vic title
# and 3 buttons: <br>
#    <dd> toggle Settings (<i>controlWindow</i>)
#    <dd> toggle Help (<i>helpWindow</i>)
#    <dd> Quit (<i>exitCmd</i>)
# <br>
# The caller is responsible for instantiating and packing <i>w</i>.
#
VicUI instproc build_menubar { w controlWindow helpWindow exitCmd } {
	frame $w -relief ridge -borderwidth 2
	label $w.title -text "[$self get_option appname] v[version]" -font [$self get_option smallfont] \
		-relief flat -justify left
	button $w.quit -text Quit -relief raised \
		-font [$self get_option smallfont] -command $exitCmd \
		-highlightthickness 1
	button $w.menu -text Settings -relief raised \
		-font [$self get_option smallfont] -highlightthickness 1 \
		-command "$controlWindow toggle"
	button $w.help -text Help -relief raised \
		-font [$self get_option smallfont] -highlightthickness 1 \
		-command "$helpWindow toggle"

	pack $w.title -side left -fill both -expand 1
	pack $w.menu $w.help $w.quit -side left -padx 1 -pady 1
}

#
# Set the title and iconname of the window "." to <i>prefix name</i>.
#
VicUI instproc window-title { prefix name } {
	$self instvar name_ prefix_
	set name_ $name
	set prefix_ $prefix

	wm iconname . "$prefix_ $name_"
	wm title . "$prefix_ $name_"

	#FIXME
	proc mark_icon mark "$self mark-icon \$mark"
}

#
VicUI instproc mark-icon mark {
	$self instvar name_ prefix_
	global current_icon_mark
	if {$mark != $current_icon_mark} {
		set current_icon_mark $mark
		append mark $prefix_$name_
		wm iconname . $mark
	}
}

#
# Build the user-interface.
# FIXME Get rid of this "spec" argument...
VicUI instproc init { w localChannel globalChannel videoAgent vpipe exitCmd {vspec {}} {scrollbars_on 0} {autoplace 0} {CINDY_HACK_HAVE_VIDEO 1} } {
	$self next

	$self instvar localChannel_ globalChannel_ videoAgent_ vpipe_ exitCmd_ scrollbars_on_ autoplace_
	set localChannel_ $localChannel
	set globalChannel_ $globalChannel
	set videoAgent_ $videoAgent
	set vpipe_ $vpipe
	set exitCmd_ "$exitCmd"
	set scrollbars_on_ $scrollbars_on
	set autoplace_ $autoplace

	# FIXME this is a temporary hack while cindy works on decomposing VicUI so that MuiUI doesn't subclass from it...
	# remove from args above and "$self next" call of MuiU::init
	if !$CINDY_HACK_HAVE_VIDEO {
		$self layout_gui $w
		set conf [$self get_option conferenceName]
	} else {
		# let this ui be an observer of the VideoAgent so it can catch "trigger_sdes"
		$videoAgent attach $self

		$self build_gui $w

		if { $vspec == "" } {
			set conf "Contacting MeGa..."
		} else {
			set conf [$self get_option conferenceName]
		}
	}

	# set the window & icon title from the conference name
	set prefix [$self get_option iconPrefix]
	$self window-title $prefix $conf

	$self set-geometry

	if [$self yesno transmitOnStartup] {
		#FIXME
		[$self set controlMenu_] build_window
		[$self set controlMenu_] invoke_transmit
	}

	$self init_keybindings "$exitCmd_"
        wm protocol . WM_DELETE_WINDOW "$exitCmd_"
}

#
VicUI instproc reset {} {
	$self new_hostspec

	set conf [$self get_option conferenceName]
	$self window-title [$self get_option iconPrefix] $conf
}

#
# Initialize some shortcut keys.
#
VicUI public init_keybindings { exitCmd } {
	#
	# emulate implicit keyboard focus
	#
	bind . <Enter> { focus %W }
	#wm focusmodel . active
	bind . <q> "$exitCmd"
	bind . <Control-c> "$exitCmd"
	bind . <Control-d> "$exitCmd"
}

#
# Given widget <i>w</i>, create frame $w.top, initializing its visual and colormap.
# Within this frame, a frame ($w.top.f) is created for holding either a label (instvar label_)
# or another frame (instvar grid_).
# A few keybinbdings are assigned.
#
VicUI instproc build_gui { w } {
	$self instvar videoAgent_ userwindows_ path_ vpipe_ asm_ localChannel_ globalChannel_

	$self set_rate_vars [$videoAgent_ set session_]

	$self instvar id_
	set id_ [after 1000 "$self periodic_update"]

	#
	# Configure the Switcher class to ignore attempts to switch
	# to the local source, since this is not interesting (unless
	# we set the "vain" configuration option to true).
	#
	if { ![$self yesno vain] && [$videoAgent_ have_network] } {
		Switcher set ignore_([$videoAgent_ local]) 1
	}

	$self layout_gui $w

	#
	# Local coordination bus events
	# - receive a focus speaker message from vat running on the
	#   same machine as this vic
	#
	set cb $localChannel_
	if { $cb != "" } {
		$cb register FOCUS_SPEAKER "$asm_ focus_speaker"
	}

	#
	# Global coordination bus events
	# - receive a aware {ear,hand,yes,no} message from vat
	#   running on others machine
	# - receive an unaware of the same types
	#
	# CuesReceiver handle these events, this is created only
	# when the user specified to do so on the command line
	#
	set cb $globalChannel_
	if { [$self yesno useCues] && $cb!="" }  {
		CuesReceiver set_cb $cb
	}

	# Camera Control
	if [$self yesno camctrl] {
		puts "camera controls enabled..."
		$self instvar camMngr_
		set camMngr_ [new CameraManager]
	}
}

#
# If the thumbnail container is resized, change the scrollable region
# of the canvas to be the larger of the thumbnail container or the vic
# window size.
#
VicUI public rearrange {w h} {
    $self instvar asm_canvas_ asm_width_ asm_height_ manual_width_ manual_height_ scrollbars_on_

    # Remember the new thumbnail container's size.
    set asm_width_ $w
    set asm_height_ $h

    if { $scrollbars_on_ } {
	# Set the scrollable region to the larger of the thumbnail size and
	# the vic window size.
	set w [expr $asm_width_ > $manual_width_ ? $asm_width_ : $manual_width_]
	set h [expr $asm_height_ > $manual_height_ ? $asm_height_ : $manual_height_]
	$asm_canvas_ configure -scrollregion "0 0 $w $h"
    } else {
	# Resize the entire vic window to match the thumbnail size.
	$asm_canvas_ configure -width $w -height $h
    }

    # Re-anchor the thumbnail container if necessary.
    $self reanchor_asm
}

#
# If the vic window is resized, change the scrollable region of the canvas
# to be the larger of the thumbnail container or the vic window size.
#
VicUI public reconfine {w h} {
    $self instvar asm_canvas_ asm_width_ asm_height_ manual_width_ manual_height_

    # Remember the new vic window size.
    set manual_width_ $w
    set manual_height_ $h

    # Set the scrollable region to the larger of the thumbnail size and
    # the vic window size.
    set w [expr $manual_width_ > $asm_width_ ? $manual_width_ : $asm_width_]
    set h [expr $manual_height_ > $asm_height_ ? $manual_height_ : $asm_height_]
    $asm_canvas_ configure -scrollregion "0 0 $w $h"

    # Re-anchor the thumbnail container if necessary.
    $self reanchor_asm
}

#
# Toggle the thumbnail scrollbars on and off.
#
VicUI public toggle_scrollbars {} {
    $self instvar scrollbars_on_
    if { $scrollbars_on_ } {
	$self scrollbars_off
    } else {
	$self scrollbars_on
    }
}

VicUI public scrollbars_off {} {
    $self instvar asm_canvas_ asm_grid_ scrollbars_on_

    if { $scrollbars_on_ } {
	grid $asm_canvas_ -in $asm_grid_ -padx 1 -pady 1 \
		-row 0 -column 0 -rowspan 2 -columnspan 2 -sticky news
    }
    set scrollbars_on_ 0
}

VicUI public scrollbars_on {} {
    $self instvar asm_canvas_ asm_grid_ asm_vscroll_ asm_hscroll_ scrollbars_on_

    if { ! $scrollbars_on_ } {
	grid $asm_canvas_ -in $asm_grid_ -padx 1 -pady 1 \
		-row 0 -column 0 -rowspan 1 -columnspan 1 -sticky news
	grid $asm_vscroll_ -in $asm_grid_ -padx 1 -pady 1 \
		-row 0 -column 1 -rowspan 1 -columnspan 1 -sticky news
	grid $asm_hscroll_ -in $asm_grid_ -padx 1 -pady 1 \
		-row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news
    }
    set scrollbars_on_ 1
}

#
# Hook to set the scrollbars from outside the main UI using tkvar.
#
VicUI public set_scrollbars {} {
    $self tkvar useScrollbars_

    if { $useScrollbars_ } {
	$self scrollbars_on
    } else {
	$self scrollbars_off
    }
}

#
# If the ActiveSourceManager has video streams, anchor it to the NW
# corner of the scrolling canvas. If no video streams have ever been
# received, then re-center it. This assumes that even if there are
# no active streams, the ActiveSourceManager continues to display
# thumbnails.
#
VicUI public reanchor_asm {} {
    $self instvar asm_ asm_canvas_ asm_window_id_ asm_anchored_ manual_width_ manual_height_

    # Don't do anything if the number of sources hasn't changed from
    # zero to non-zero.
    set num_sources [llength [$asm_ active-sources]]
    if {$asm_anchored_} return

    # If no video streams have ever been received, re-center the
    # ActiveSourceManager. Otherwise anchor it to the NW corner and
    # don't do any more reanchoring.
    if {!$asm_anchored_ && [llength [$asm_ active-sources]] == 0} {
	$asm_canvas_ delete $asm_window_id_
	set asm_window_id_ [$asm_canvas_ create window [expr $manual_width_ / 2] [expr $manual_height_ / 2] -anchor center -window $asm_canvas_.top]
    } else {
	$asm_canvas_ delete $asm_window_id_
	set asm_window_id_ [$asm_canvas_ create window 0 0 -anchor nw -window $asm_canvas_.top]
	set asm_anchored_ 1
    }
}

#
# Create the main vic window.
#
VicUI public layout_gui {w} {
	$self instvar asm_ controlMenu_ videoAgent_ vpipe_ vframe_ exitCmd_ localChannel_ asm_canvas_ asm_grid_ asm_width_ asm_height_ manual_width_ manual_height_ scrollbars_on_ asm_vscroll_ asm_hscroll_ asm_window_id_ asm_anchored_ autoplace_

	# Set the default scrolling parameters.
	set asm_canvas_ $w.asm_canvas
	set asm_grid_ $w.asm_grid
	set asm_vscroll_ $w.asm_vscroll
	set asm_hscroll_ $w.asm_hscroll
	set asm_width_ 0
	set asm_height_ 0
	set manual_width_ 173
	set manual_height_ 140
	set asm_anchored_ 0

	# Create a surrounding canvas for the ActiveSourceManager's
	# enclosing frame to provide scrolling capability.
	frame $asm_grid_
	scrollbar $asm_hscroll_ -orient horiz -command "$w.asm_canvas xview"
	scrollbar $asm_vscroll_ -orient vert -command "$w.asm_canvas yview"
	canvas $asm_canvas_ -width $manual_width_ -height $manual_height_ \
		-highlightthickness 0 -scrollregion "0 0 $manual_width_ $manual_height_" \
		-xscrollcommand "$w.asm_hscroll set" \
		-yscrollcommand "$w.asm_vscroll set"

	# Layout the scroll canvas and widgets.
	pack $asm_grid_ -expand yes -fill both -padx 1 -pady 1
	grid rowconfig $asm_grid_ 0 -weight 1 -minsize 0
	grid columnconfig $asm_grid_ 0 -weight 1 -minsize 0
	if { $scrollbars_on_ } {
		grid $asm_canvas_ -in $asm_grid_ -padx 1 -pady 1 \
			-row 0 -column 0 -rowspan 1 -columnspan 1 -sticky news
		grid $asm_vscroll_ -in $asm_grid_ -padx 1 -pady 1 \
			-row 0 -column 1 -rowspan 1 -columnspan 1 -sticky news
		grid $asm_hscroll_ -in $asm_grid_ -padx 1 -pady 1 \
			-row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news
	} else {
		grid $asm_canvas_ -in $asm_grid_ -padx 1 -pady 1 \
			-row 0 -column 0 -rowspan 2 -columnspan 2 -sticky news
	}

	# Create the source manager and a vframe to enclose it.
	set vframe_ [new VisualFrame $asm_canvas_.top]
	set asm_ [new ActiveSourceManager $self $asm_canvas_.top $videoAgent_ vertical $localChannel_ $autoplace_]
	$vframe_ attach_observer $asm_
	$asm_ redecorate 3
	$asm_ init_grid $asm_canvas_.top.f

	# Pack the thumbnail frames.
	pack $asm_canvas_.top -expand 1 -fill both
	pack $asm_canvas_.top.f -expand 1 -fill both -side top

	# Place the thumbnails into the scrollable canvas.
	set asm_window_id_ [$asm_canvas_ create window [expr $manual_width_ / 2] [expr $manual_height_ / 2] -anchor center -window $asm_canvas_.top]

	# Build the control menu and the vic bottom menubar.
	set controlMenu_ [new ControlMenu $self $videoAgent_ $vpipe_ $vframe_ $asm_ [new UISrcListWindow $w $videoAgent_]]
	$self build_menubar $w.asm_bar $controlMenu_ [new VicHelpWindow .help] "$exitCmd_"
	grid $w.asm_bar -in $asm_grid_ -padx 1 -pady 1 \
		-row 2 -column 0 -rowspan 1 -columnspan 2 -sticky news

	# Attach some behavior.
	bind $asm_canvas_.top.f <Configure> "$self rearrange %w %h"
	bind $asm_canvas_ <Configure> "$self reconfine %w %h"
	foreach i { 1 2 3 4 5 6 7 8 } {
		bind . <Key-$i> "$asm_ redecorate $i; $controlMenu_ update_layout $i"
	}
	#FIXME a bit dangerous to have this in the GUI
	bind . <t> "$controlMenu_ build_window ; $controlMenu_ invoke_transmit"
	bind . <s> "$self toggle_scrollbars; $controlMenu_ toggle_scrollcheck"
	bind . <a> "$asm_ toggle_autoplace; $controlMenu_ toggle_autocheck"
}

#
# An accessor function for a ControlMenu tkvar value.
#
VicUI public use_hw_decode {} {
	$self instvar controlMenu_
	return [$controlMenu_ use-hw]
}

#
# An accessor function for a ControlMenu tkvar value.
#
VicUI public mute_new_sources {} {
	$self instvar controlMenu_
	return [$controlMenu_ mute-new-sources]
}

#VicUI instproc cb_switcher msg {
#	$self instvar videoAgent_
#	foreach s [$videoAgent_ active_list] {
#		#
#		# look up the site by cname.  (for backward compat
#		# with old vat's, try the IP address too)
#		#
#		if { [$s addr] == $msg || [$s sdes cname] == $msg } {
#			Switcher focus $s
#			return
#		}
#	}
#}

#
# Size the "." window using values from the resource database:
# <i>minwidth</i>, <i>minheight</i>, and <i>geometry</i> (all in
# pixels).  Specify <i>geometry</i> in the form wXh or set it to empty
# string, {}, to cancel the existing user-specified geometry and revert
# to the size requested internally by its widgets.
#
VicUI instproc set-geometry {} {
	#
	# Withdraw window so that user-placement is deferred
	# until after initial geometry is computed
	#
	global mash
	if { ![info exists mash(environ)] || $mash(environ)!="mplug" } {
	    wm withdraw .
	}
	wm geometry . [$self get_option geometry]
	update idletasks
	set minwidth [winfo reqwidth .]
	set minheight [winfo reqheight .]
	#FIXME
	if { $minwidth < [$self get_option minwidth] } {
		set minwidth [$self get_option minwidth]
	}
	if { $minheight < [$self get_option minheight] } {
		set minheight [$self get_option minheight]
	}
	wm minsize . $minwidth $minheight
	if { ![info exists mash(environ)] || $mash(environ)!="mplug" } {
		wm deiconify .
	}
}

#
# Every second, update rate variables.
#
VicUI instproc periodic_update { } {
	$self instvar videoAgent_ vpipe_ id_
	if [$vpipe_ running] {
		update_rate [$videoAgent_ set session_]
	}
	update idletasks
	set id_ [after 1000 "$self periodic_update"]
}

#
VicUI instproc clean_timers { } {
	$self cancel_periodic_update
}

#
# Cancels the periodic_update.
#
VicUI instproc cancel_periodic_update { } {
        $self instvar id_
        if [info exists id_] {
                after cancel $id_
                unset id_
        }
}

#
# For the video source, <i>src</i>, set the rate variables.
#
VicUI instproc set_rate_vars {src} {
	global fpshat bpshat lhat shat
	if [info exists fpshat($src)] {
		unset fpshat($src)
		unset bpshat($src)
		unset lhat($src)
		unset shat($src)
	}
	set gain [$self get_option filterGain]
	set fpshat($src) 0
	rate_variable fpshat($src) $gain
	set bpshat($src) 0
	rate_variable bpshat($src) $gain
	set lhat($src) 0
	rate_variable lhat($src) $gain
	set shat($src) 0
	rate_variable shat($src) $gain

#FIXME set guys in stat window too!
}

#
VicUI instproc new_hostspec {} {
	$self instvar controlMenu_
	if [info exists controlMenu_] {
		$controlMenu_ new_hostspec
	}
}

#
# Update the source description by updating the element of the global
# arrays src_info(), src_nickname(), and src_name() indexed by the
# specified <i>src</i>.  If the src_name() is changed, then this is
# reflected in the UserWindows in which this src appears.
#
VicUI instproc trigger_sdes src {
	$self instvar asm_

	global src_info src_nickname src_name
	#
	# Figure out best presentation from available information.
	#
	set name [$src sdes name]
	set cname [$src sdes cname]
	set addr [$src addr]
	if { $name == "" } {
		if { $cname == "" } {
			set src_nickname($src) $addr
			set info $addr/[$src format_name]

		} else {
			set src_nickname($src) $cname
			set info "$addr/[$src format_name]"
		}
	} elseif [cname_redundant $name $cname] {
		set src_nickname($src) $name
		set info $addr/[$src format_name]
	} else {
		set src_nickname($src) $name
		set info $cname/[$src format_name]
	}
	set msg [$src sdes note]
	if { $msg != "" } {
		set info $msg
	}
	set src_info($src) $info

	# only call change_name when name really changes
	if { ![info exists src_name($src)] || "$src_name($src)" != "$name" } {
		set src_name($src) $name
		$asm_ change_name $src
	}
}

#
VicUI instproc trigger_media src {}

#
# For the source specified by <i>src</i>, update its rate variables and its source description.
#
VicUI instproc update_decoder src {
	$self set_rate_vars $src
	$self trigger_sdes $src
}

VicUI instproc scuba_session {} {
	$self instvar scuba_sess_
	if [info exists scuba_sess_] { return $scuba_sess_ }  else {return "" }
}

#
# switch the VideoAgent object in charge of the M/C session. 
#
VicUI instproc switch-agent {spec} {
	$self instvar videoAgent_
	$self instvar vpipe_
	$self instvar asm_ controlMenu_

	# create the new agent (this has to be done before deleting the old one
	# to avoid problems due to an encoder trying to give a packet to a
	# non-existent VideoAgent)
	if {[catch {new VideoAgent $self $spec} new_agent]} {
		error $new_agent
	}


	# set the local output BufferPool (VideoPipeline::bufferPool_) right
	if {[$vpipe_ info vars bufferPool_] == "bufferPool_"} {
		[$vpipe_ set bufferPool_] srcid [$new_agent get_local_srcid]
	}


	# fix the local output encoder's target
	#	$videoAgent attach $self; # XXXX
	if {[$vpipe_ info vars encoder_] == "encoder_"} {
		[$vpipe_ set encoder_] target [$new_agent get_transmitter]
	}


	# fix the VideoAgent handler at the VideoPipeline
	$vpipe_ set session_ $new_agent


	# transfer all the objects attached to the old VideoAgent to the new one
	foreach observer [$videoAgent_ set observers_] {
		$new_agent attach $observer
	}


	# configure the Switcher class to ignore attempts to switch
	# to the local source, since this is not interesting (unless
	# we set the "vain" configuration option to true).
	#
	if { ![$self yesno vain] && [$new_agent have_network] } {
		Switcher set ignore_([$new_agent local]) 1
	}

	# report the new VideoAgent to all the UI components
	$asm_ switch-agent $new_agent
	$controlMenu_ switch-agent $new_agent


	# report the new VideoAgent to the VicApplication object
	# Note: it's a little tricky to get the VicApplication object by querying for 
	# objects of this type, but the fact is that currently the UI doesn't keep a 
	# handler to the VicApplication
	if {[llength [VicApplication info instances]] > 0} {
		[lindex [VicApplication info instances] 0] set agent_ $new_agent
	}

	# destroy the old VideoAgent and link the ControlMenu to the new one
	$videoAgent_ destroy
	set videoAgent_ $new_agent

}


#
# Using the specified video source, <i>src</i>, as an index, update the
# global arrays bpshat(), fpshat(), shat(), lhat(), ltext(), ftext(), btext().
#
proc update_rate src {
	global ftext btext ltext fpshat bpshat lhat shat V

	set key $src
	if [string match Session/* [$src info class]] {
		set bpshat($key) [expr 8 * [$src set nb_]]
		set fpshat($key) [$src set nf_]
	} else {
		# only compute loss statistic for network side
		set p [$src layer-stat np_]
		set s [$src ns]
		set shat($key) $s
		set lhat($key) [expr $s-$p]
		if {$shat($key) <= 0.} {
			set loss 0
		} else {
			set loss [expr 100*$lhat($key)/$shat($key)]
		}
		if {$loss < .1} {
			set ltext($key) (0%)
		} elseif {$loss < 9.9} {
			set ltext($key) [format "(%.1f%%)" $loss]
		} else {
			set ltext($key) [format "(%.0f%%)" $loss]
		}
		set bpshat($key) [expr 8 * [$src layer-stat nb_]]
		set fpshat($key) [$src layer-stat nf_]
	}

	set fps $fpshat($key)
	set bps $bpshat($key)

	if { $fps < .1 } {
		set fps "0 f/s"
	} elseif { $fps < 10 } {
		set fps [format "%.1f f/s" $fps]
	} else {
		set fps [format "%2.0f f/s" $fps]
	}
	if { $bps < 1 } {
		set bps "0 bps"
	} elseif { $bps < 1000 } {
		set bps [format "%3.0f bps" $bps]
	} elseif { $bps < 1000000 } {
		set bps [format "%3.0f kb/s" [expr $bps / 1000]]
	} else {
		set bps [format "%.1f Mb/s" [expr $bps / 1000000]]
	}
	set ftext($key) $fps
	set btext($key) $bps
}

#
# A toggle-able dismissable toplevel window for displaying a bulleted list of tips to help the vic user.
#
Class VicHelpWindow -superclass HelpWindow

#
# Instantiate, but do not yet display or iconify, a dismissable toplevel
# window using the provided widgetpath, <i>w</i>.  Within <i>w</i>,
# create a bulleted list of tips to help the vic user.  (This method is
# called when the user toggles this window for the first time.)
#
VicHelpWindow instproc build w {

	$self create-window $w "Help" {

"Transmit video by clicking on the ``Transmit'' button \
in the ``Menu'' window.  You need video capture hardware to do this."

"Incoming video streams appear in the main vic window.  \
If you see the message ``Waiting for video...'', then no one is transmitting \
video to the conference address you're running on.  Otherwise, you'll \
see a thumbnail sized image and accompanying information for each source. \
Click on the thumbnail to open a larger viewing window.  You can tile the \
thumbnails in multiple columns using the ``Tile'' menu in the ``Menu'' window."
"Clicking on the ``mute'' button for a given source will \
turn off decoding.  It is usually a good idea to do \
this for your own, looped-back transmission."

"The transmission rate is controlled with the bit-rate \
and frame-rate sliders in the ``Transmission'' panel of the ``Menu'' window.  \
The more restrictive setting limits the transmission rate."

"The video windows need not be fixed to a given source. \
The ``Mode...'' menu attached to a viewing window allows you to specify \
voice-switched and/or timer-switched modes.   In timer-switched mode, the \
window automatically cycles through (unmuted) sources, while in \
oice-switched mode, the window switches to whomever is talking \
(using cues from vat).  You can have more than one voice-switched window, \
which results in a simple LRU allocation of the windows to most recent \
speakers.  See the man page for more details."

"If the user interface looks peculiar, you might \
have X resources that conflict with tk.  A common problem is \
defining ``*background'' and/or ``*foreground''."

"Bugs and suggestions to openmash-users@openmash.org.  Thanks."
	}
}

#
# Build the audio user-interface for the AudioAgent, <i>agent</i>.
#
VicUI instproc create-audio-ui agent {
	$self instvar audioUI_ path_
	set audioUI_ [new VicAudioUI $path_.top.f $self $agent]
}

#
# Don't use this class.  It will be obsoleted soon.
#
Class VicAudioUI

#
VicAudioUI instproc init { w mainUI agent } {
	$self instvar mainUI_ panel_
	set mainUI_ $mainUI

	set panel_ [new AudioPanel $w $agent]

	#FIXME
	global meterDisable
	set meterDisable 0
	$panel_ install_meters

	#FIXME mute mike
	$panel_ ptt-release
	$agent select_format PCM 2
}

#
VicAudioUI instproc destroy {} {
	$self instvar panel_
	delete $panel_
}

#
VicAudioUI instproc register src {
	puts "VicAudioUI::register [$src getid]"
}

#
VicAudioUI instproc activate src {
	puts "ACTIVATE: [$src getid]"
}

#
VicAudioUI instproc trigger_media src {
	puts "AUDIO-FROM: [$src getid]"
}

#
VicAudioUI instproc trigger_idle src {
	puts "IDLE: [$src getid] [$src lost]"
}

#
VicAudioUI instproc trigger_sdes src {
	puts "SDES: [$src getid]"
}

