# example.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/srmv2/example/example.tcl,v 1.7 2002/02/03 03:04:55 lim Exp $


proc srm_recv { source cid seqno data } {
	write_file [get_filename $cid] $data
}


proc srm_should_recover { source cid sseq eseq } {
	return 1
}


proc srm_read_adu { source cid seqno } {
	return [read_file [get_filename $cid]]
}


proc srm_source_update { src info } {
	puts "got source $src: $info"
}


proc srm_recv_cid { src cid parent_cid name } {
	global cid_names_ cid_parents_
	set cid_names_($cid) $name
	set cid_parents_($cid) $parent_cid
}


proc write_file { name data } {
	regsub -all {/} $name - new_name
	puts "^^^^^^^^^^^^^^^ '$name' becomes '$new_name'"
	set f [open [file join /tmp $new_name] "w" 0644]
	fconfigure $f -translation binary
	puts -nonewline $f $data
	close $f
}


proc read_file { name } {
	set f [open $name]
	set data ""
	while ![eof $f] {
		append data [read $f 4096]
	}
	close $f
	return $data
}


proc get_filename { cid } {
	global cid_names_ cid_parents_ SRMv2_ROOT_CID
	if ![info exists cid_names_($cid)] { return "" }
	set name ""
	while { $cid!=$SRMv2_ROOT_CID && $cid!= $cid_parents_($cid) } {
		set name [file join $cid_names_($cid) $name]
		set cid $cid_parents_($cid)
	}
	return $name
}


proc my_srm_calloc { source parent_cid cid_name } {
	global cid_names_ cid_parents_
	set cid [srm_calloc $source $parent_cid $cid_name]
	set cid_names_($cid) $cid_name
	set cid_parents_($cid) $parent_cid
	return $cid
}


proc send_dir { source dirname parent_cid } {
	set files [glob [file join $dirname "*"]]
	set parent_cid [my_srm_calloc $source $parent_cid [file tail $dirname]]
	foreach file $files {
		if [file isdirectory $file] {
			send_dir $source $file $parent_cid
		} elseif [file isfile $file] {
			set cid [my_srm_calloc $source $parent_cid \
					[file tail $file]]
			srm_send $source $cid [read_file $file]
		}
	}
}


proc send_data { source dirname } {
	global SRMv2_ROOT_CID
	send_dir $source $dirname $SRMv2_ROOT_CID
}


if { [llength $argv] != 3 && [llength $argv] != 4} {
	puts stderr "Usage: $argv0 <addr> <port> <ttl> ?dir?"
	exit
}

if { [lsearch [package names] Tk] != -1 } {
	wm withdraw .
}
set SRMv2_ROOT_CID 0

set addr [lindex $argv 0]
set port [lindex $argv 1]
set ttl  [lindex $argv 2]
set data [lindex $argv 3]

set session [srm_create_session $addr $port $port $ttl]
set source [srm_create_source $session]
srm_callbacks $session srm_recv srm_should_recover srm_read_adu \
		srm_source_update srm_recv_cid


if { $data != {} } {
	send_data $source $data
}


if { [lsearch [package names] Tk] == -1 } {
	vwait forever
}
