# tclcl.tcl --
#
#       This file contains a brief tutorial of TclCL.
#
#       You can try these examples by starting smash or mash and then typing
#       'source tclcl.tcl'.
#
# Copyright 2001 ??


# OTcl is an extension to Tcl/Tk for object-oriented programming.  OTcl's
# syntax mirrors Tcl syntax and Tk widget syntax.  OTcl has a C API that allows
# methods to be written in C.

# TclCL adds a layer of C++ glue to OTcl.  TclCL adds syntax that is similar to
# C++ syntax.  TclCL has a C++ API that .


# TclCL does not change the way classes are defined.  Classes are defined the
# same way as in OTcl.

# To define a class:

Class Bagel
Class SpreadableBagel -superclass Bagel

# To define a constructor:

Bagel instproc init {args} {
    $self set toasted 0
    eval $self next $args
    puts "$self: fresh!"
}

# To define a method:

Bagel instproc toast {} {
    $self instvar toasted
    incr toasted
    if {$toasted > 1} {
        puts "$self: something's burning!"
    } else {
        puts "$self: toasted!"
    }
    return
}

# To define a destructor:

Bagel instproc destroy {} {
     puts "$self: zap!"
     $self next
}


# TclCL adds a different syntax for manipulating objects.

# To create an object:

#   Using OTcl:

Bagel otclBagel

#   Using TclCL:

set tclclBagel [new Bagel]

# To invoke a method:

#   Using OTcl:

otclBagel toast
otclBagel toast

#   Using TclCL:

$tclclBagel toast
$tclclBagel toast

# To destroy an object:

#   Using OTcl:

otclBagel destroy

#   Using TclCL:

delete $tclclBagel
