/**********************************************************************
 *
 *	FILE:			ConvexPlanarPolygon.cpp
 *
 *	DESCRIPTION:	Read/Write osg::ConvexPlanarPolygon in binary format to disk.
 *
 *	CREATED BY:		Auto generated by iveGenerator
 *					and later modified by Rune Schmidt Jensen.
 *
 *	HISTORY:		Created 23.4.2003
 *
 *	Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "ConvexPlanarPolygon.h"

using namespace ive;

void ConvexPlanarPolygon::write(DataOutputStream* out){
	// Write ConvexPlanarPolygon's identification.
	out->writeInt(IVECONVEXPLANARPOLYGON);
	// If the osg class is inherited by any other class we should also write this to file.
	//osg::Object*  obj = dynamic_cast<osg::Object*>(this);
	//if(obj){
	//	((ive::Object*)(obj))->write(out);
	//}
	//else
	//	throw Exception("ConvexPlanarPolygon::write(): Could not cast this osg::ConvexPlanarPolygon to an osg::Object.");
	// Write ConvexPlanarPolygon's properties.

	// Write Vertex list
	VertexList vertexList = getVertexList();
	int size = vertexList.size();
	out->writeInt(size);
	for(int i=0; i<size; i++){
		out->writeVec3(vertexList[i]);
	}

}

void ConvexPlanarPolygon::read(DataInputStream* in){
	// Peek on ConvexPlanarPolygon's identification.
	int id = in->peekInt();
	if(id == IVECONVEXPLANARPOLYGON){
		// Read ConvexPlanarPolygon's identification.
		id = in->readInt();
		// If the osg class is inherited by any other class we should also read this from file.
		//osg::Object*  obj = dynamic_cast<osg::Object*>(this);
		//if(obj){
		//	((ive::Object*)(obj))->read(in);
		//}
		//else
		//	throw Exception("ConvexPlanarPolygon::read(): Could not cast this osg::ConvexPlanarPolygon to an osg::Object.");
		// Read ConvexPlanarPolygon's properties

		// Read Vertex list
		int size = in->readInt();
		for(int i=0; i<size; i++){
			add(in->readVec3());
		}

	}
	else{
		throw Exception("ConvexPlanarPolygon::read(): Expected ConvexPlanarPolygon identification.");
	}
}
