/**********************************************************************
 *
 *    FILE:           BlendColor.cpp
 *
 *    DESCRIPTION:    Read/Write osg::BlendColor in binary format to disk.
 *
 *    CREATED BY:     Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *                    and then some more by Ulrich Hertlein
 *
 *    HISTORY:        Created 21.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "BlendColor.h"
#include "Object.h"

#include <osg/Notify>
#include <iostream>

using namespace ive;

void BlendColor::write(DataOutputStream* out)
{
    // Write BlendColor's identification.
    out->writeInt(IVEBLENDCOLOR);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object* obj = dynamic_cast<osg::Object*>(this);
    if (obj) {
        ((ive::Object*)(obj))->write(out);
    } else {
        throw Exception("BlendColor::write(): Could not cast this osg::BlendColor to an osg::Object.");
    }
    // Write BlendColor's properties.

    // Write constant color
    out->writeVec4(getConstantColor());
}

void BlendColor::read(DataInputStream* in)
{
    // Peek on BlendColor's identification.
    int id = in->peekInt();
    if (id == IVEBLENDCOLOR) {
        // Read BlendColor's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if (obj) {
            ((ive::Object*)(obj))->read(in);
        } else {
            throw Exception("BlendColor::read(): Could not cast this osg::BlendColor to an osg::Object.");
        }
        // Read BlendColor's properties

        // Read constant color
        setConstantColor(in->readVec4());

    } else {
        throw Exception("BlendColor::read(): Expected BlendColor identification.");
    }
}
