##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from common import record_id


class IDRecorderTestCase(unittest.TestCase):

    ## Initial Set UP
    setattr(record_id.IDRecorder, 'id_file', './test/unit_test/work/input/id_file.pickle')
    setattr(record_id.IDRecorder, 'start_id', '1000')
    recorder_obj = record_id.IDRecorder()
    recorder_obj.recordFinal()


    def test_recordFinal(self):
        print "\nTesting ID Recorder Test Suite ..."
        req_out_put = None
        id_dict = {'firefox_34':1000, 'kernel_49':1001}
        setattr(record_id.IDRecorder, 'pickle_id_dict', id_dict)
        out_put = self.recorder_obj.recordFinal()
        self.assertEquals(out_put, req_out_put)

    def test_recordID(self):
        req_out_put = None
        new_id = 1010
        link_id = 'opera_01'

        out_put = self.recorder_obj.recordID(new_id, link_id)
        self.assertEquals(out_put, req_out_put)


    def test_getID(self):
        req_out_put = 1002
        link_id = 'cups_039'

        out_put = self.recorder_obj.getID(link_id)
        self.assertEquals(out_put, req_out_put)


    def setUp(self):
        id_dict = {'firefox_34':1000, 'kernel_49':1001}
        setattr(record_id.IDRecorder, 'pickle_id_dict', id_dict)
        out_put = self.recorder_obj.recordFinal()


if __name__ == '__main__':
    unittest.main()
