
#
# This script was written by H D Moore
# 


if(description)
{
    script_id(10778);
    script_version ("$Revision: 8098 $");
    script_tag(name:"cvss_base", value:"4.6");
    script_tag(name:"risk_factor", value:"Medium");
    script_cve_id("CVE-1999-0508");
    name = "Unprotected SiteScope Service";
    script_name(name);


    desc = "
The SiteScope web service has no password set. An attacker
who can connect to this server could view usernames and
passwords stored in the preferences section or reconfigure
the service.

Solution: Make sure that a password is set in the configuration 
for this service. Depending on where this server is located, 
you may want to restrict access by IP address in addition to 
username.

Risk factor : High";


    script_description(desc);


    summary = "Unprotected SiteScope Service";
    script_summary(summary);


    script_category(ACT_ATTACK);

    script_copyright("This script is Copyright (C) 2001 Digital Defense Inc.");

    family = "Web application abuses";
    script_family(family);
    script_dependencie("find_service.nes", "http_version.nasl");
    script_require_ports("Services/www", 8888);
    
    exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");

function sendrequest (request, port)
{
    
    reply = http_keepalive_send_recv(port: port, data:request);
    if ( reply == NULL ) exit(0);
    else return reply;
}

#
# The script code starts here
#


ports = add_port_in_list(list:get_kb_list("Services/www"), port:8888);
foreach port (ports)
{
 req = http_get(item:"/SiteScope/cgi/go.exe/SiteScope?page=eventLog&machine=&logName=System&account=administrator", port:port);
 reply = sendrequest(request:req, port:port);

 if ("Event Log" >< reply)
 {
    security_hole(port:port);
 }
}
