###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Apache PHP HPSBUX00207
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835040);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "00207");
  script_name( "HP-UX Update for Apache PHP HPSBUX00207");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identifiedwith HP-UX running 
  Apache PHP where a remote user may cause a Denial of Service (DoS) or gain 
  increased privileges or execution of arbitrary code. 

  Impact:
  Remote Denial of Service (DoS) or  increased privileges or execution of arbitrary code.

  Affected Software/OS:
  Apache PHP on
  HP-UX B.11.00, B.11.11, B.11.20, B.11.22 running the ApacheStrong or 
  HPApache HP-UX Apache-based Web 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00943248-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Apache PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.APACHE-STRONG", revision:"1.3.26.03", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.PHP", revision:"2.0.0.00.11", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.PHP2", revision:"2.0.0.00.11", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.APACHE-STRONG", revision:"1.3.26.03", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.PHP", revision:"2.0.0.00.11", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.PHP2", revision:"2.0.0.00.11", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.20")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.APACHE-STRONG", revision:"1.3.26.03", rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.PHP", revision:"2.0.0.00.11", rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.PHP2", revision:"2.0.0.00.11", rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.APACHE-STRONG", revision:"1.3.26.03", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.PHP", revision:"2.0.0.00.11", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.PHP2", revision:"2.0.0.00.11", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}