###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_style_object_remote_code_exe_vuln.nasl 6031 2009-12-03 11:17:55Z dec $
#
# MS Internet Explorer 'Style' Object Remote Code Execution Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Updated By
# Antu Sanadi <santu@secpod.com> on  2009-12-09
# Included the  Microsoft Bulletin MS09-072 #6097
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it undr the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800727);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2493", "CVE-2009-3671", "CVE-2009-3672",
                "CVE-2009-3673", "CVE-2009-3674");
  script_bugtraq_id(37085);
  script_name("MS Internet Explorer 'Style' Object Remote Code Execution Vulnerability");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-072.

  Vulnerability Insight:
  Multiple flaws are due to:
  - The 'tdc.ocx' ActiveX control being built with vulnerable Active Template
    Library (ATL) headers, which could allow the instantiation of arbitrary objects
    that can bypass certain security related policies.
  - Memory corruption error occurs when the browser attempts to access an object
    that has not been initialized or has been deleted, which could be exploited
    to execute arbitrary code via a specially crafted web page.
  - Memory corruption occurs when processing 'CSS' objects.
  - Race condition occurs while repetitively clicking between two elements at
    a fast rate, which could be exploited to execute arbitrary code via a
    specially crafted web page.
  - A dangling pointer during deallocation of a circular dereference for a
    CAttrArray object, which could be exploited to execute arbitrary code via
    a specially crafted web page.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code via
  specially crafted HTML page in the context of the affected system and cause
  memory corruption thus causing remote machine compromise.

  Impact Level: System

  Affected Software/OS:
  Microsoft Internet Explorer version 5.x/6.x/7.x/8.x

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS09-072.mspx

  References:
  http://www.vupen.com/english/advisories/2009/3437
  http://www.microsoft.com/technet/security/Bulletin/MS09-072.mspx

  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the vulnerable mshtml.dll file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# Check for MS09-072 Hotfix (976325)
if(hotfix_missing(name:"976325") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
dllPath += "\mshtml.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

vers = GetVer(file:file, share:share);
if(!vers){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  if(version_in_range(version:vers, test_version:"5.0", test_version2:"5.0.3882.2699") ||
     version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.2800.1641")){
    security_hole(0);
  }
}
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    if(version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.2800.1641") ||
       version_in_range(version:vers, test_version:"6.0.2900.0000", test_version2:"6.0.2900.3639")||
       version_in_range(version:vers, test_version:"7.0", test_version2:"7.0.6000.21128")||
       version_in_range(version:vers, test_version:"8.0", test_version2:"8.0.6001.18853")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    if(version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.2800.1641")||
       version_in_range(version:vers, test_version:"6.0.2900.0000", test_version2:"6.0.2900.5896")||
       version_in_range(version:vers, test_version:"7.0", test_version2:"7.0.6000.16944") ||
       version_in_range(version:vers, test_version:"7.0.6000.20000", test_version2:"7.00.6000.21128") ||
       version_in_range(version:vers, test_version:"8.0", test_version2:"8.0.6001.18853")||
       version_in_range(version:vers, test_version:"8.0.6001.00000", test_version2:"8.00.6001.22927")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    if(version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.3790.4610") ||
       version_in_range(version:vers, test_version:"7.0", test_version2:"7.0.6000.16944") ||
       version_in_range(version:vers, test_version:"7.0.6000.20000", test_version2:"7.00.6000.21128")||
       version_in_range(version:vers, test_version:"8.0", test_version2:"8.0.6001.18853")||
       version_in_range(version:vers, test_version:"8.00.6001.00000", test_version2:"8.00.6001.22927")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
